/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.util.ArrayList;
import net.sf.testium.executor.general.CheckString;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.openqa.selenium.WebElement;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.utils.RunTimeData;

public class CheckText
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "checkText";
    private static final String PAR_ELEMENT = "element";
    private static final String PAR_EXPECTED = "expected";
    private static final SpecifiedParameter PARSPEC_ELEMENT = new SpecifiedParameter("element", WebElement.class, false, false, true, false);
    private static final SpecifiedParameter PARSPEC_EXPECTED = new SpecifiedParameter("expected", String.class, false, true, true, true);

    public CheckText(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_ELEMENT);
        this.addParamSpec(PARSPEC_EXPECTED);
        this.addParamSpec(CheckString.PARSPEC_MATCH);
        this.addParamSpec(CheckString.PARSPEC_CASE);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepCommandResult result) throws Exception {
        WebElement element = this.obtainElement(aVariables, parameters, PARSPEC_ELEMENT);
        String expectedText = (String)this.obtainValue(aVariables, parameters, PARSPEC_EXPECTED);
        String actualText = CheckText.getActualText(element);
        String matchStr = (String)this.obtainOptionalValue(aVariables, parameters, CheckString.PARSPEC_MATCH);
        CheckString.MATCH match = CheckString.MATCH.enumOf((String)matchStr);
        boolean caseSensitive = (Boolean)this.obtainOptionalValue(aVariables, parameters, CheckString.PARSPEC_CASE);
        String elementName = parameters.get(PAR_ELEMENT).getName();
        result.setDisplayName(this.toString() + " " + elementName + " " + expectedText);
        CheckString.checkString((String)actualText, (String)expectedText, (CheckString.MATCH)match, (boolean)caseSensitive, (String)"Actual Text");
    }

    protected static String getActualText(WebElement elm) {
        if (elm == null) {
            return "";
        }
        if (elm.getTagName().equalsIgnoreCase("input") || elm.getTagName().equalsIgnoreCase("textarea")) {
            String text = elm.getAttribute("value");
            return text == null ? "" : text;
        }
        return elm.getText();
    }
}

