/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.configuration;

import java.util.ArrayList;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.configuration.SeleniumInterfaceConfiguration;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.TTIException;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class SeleniumInterfaceXmlHandler
extends XmlHandler {
    public static final String START_ELEMENT = "SeleniumInterface";
    private static final String BROWSER_TYPE_ELEMENT = "BrowserType";
    private static final String BASE_URL_ELEMENT = "BaseUrl";
    private static final String CUSTOMSTEP_DEFINITIONS_LINK_ELEMENT = "CustomStepDefinitionsLink";
    private GenericTagAndStringXmlHandler myBaseUrlXmlHandler;
    private GenericTagAndStringXmlHandler myBroserTypeXmlHandler;
    private GenericTagAndStringXmlHandler myCustomStepDefinitionsLinkXmlHandler;
    private GenericTagAndStringXmlHandler mySavePageSourceXmlHandler;
    private GenericTagAndStringXmlHandler mySaveScreenShotXmlHandler;
    private SeleniumConfiguration.BROWSER_TYPE defaultType;
    private String defaultBaseUrl;
    private SeleniumInterfaceConfiguration.SAVE_SOURCE defaultSavePageSource;
    private SeleniumInterfaceConfiguration.SAVE_SOURCE defaultSaveScreenShot;
    private SeleniumConfiguration.BROWSER_TYPE myType;
    private String myBaseUrl;
    private SeleniumInterfaceConfiguration.SAVE_SOURCE mySavePageSource;
    private SeleniumInterfaceConfiguration.SAVE_SOURCE mySaveScreenShot;
    private ArrayList<String> myCustomKeywordLinks;

    public SeleniumInterfaceXmlHandler(XMLReader anXmlReader, SeleniumConfiguration selConfig) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.defaultType = selConfig.getBrowserType();
        this.defaultSavePageSource = selConfig.getSavePageSource();
        this.defaultSaveScreenShot = selConfig.getSaveScreenShot();
        this.genericConstructor(anXmlReader);
    }

    public SeleniumInterfaceXmlHandler(XMLReader anXmlReader, SeleniumInterfaceConfiguration globalIfConfig) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.defaultType = globalIfConfig.getBrowserType();
        this.defaultBaseUrl = globalIfConfig.getBaseUrl();
        this.defaultSavePageSource = globalIfConfig.getSavePageSource();
        this.defaultSaveScreenShot = globalIfConfig.getSaveScreenShot();
        this.genericConstructor(anXmlReader);
    }

    private void genericConstructor(XMLReader anXmlReader) {
        this.reset();
        this.myBaseUrlXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, BASE_URL_ELEMENT);
        this.addElementHandler((XmlHandler)this.myBaseUrlXmlHandler);
        this.myBroserTypeXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, BROWSER_TYPE_ELEMENT);
        this.addElementHandler((XmlHandler)this.myBroserTypeXmlHandler);
        this.myCustomStepDefinitionsLinkXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, CUSTOMSTEP_DEFINITIONS_LINK_ELEMENT);
        this.addElementHandler((XmlHandler)this.myCustomStepDefinitionsLinkXmlHandler);
        this.mySavePageSourceXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, "SavePageSource");
        this.addElementHandler((XmlHandler)this.mySavePageSourceXmlHandler);
        this.mySaveScreenShotXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, "SaveScreenshot");
        this.addElementHandler((XmlHandler)this.mySaveScreenShotXmlHandler);
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) throws TTIException {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) throws TTIException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("handleReturnFromChildElement( " + aQualifiedName + " )"), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase(BASE_URL_ELEMENT)) {
            this.myBaseUrl = this.myBaseUrlXmlHandler.getValue();
            this.myBaseUrlXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(BROWSER_TYPE_ELEMENT)) {
            String browserTypeStr = this.myBroserTypeXmlHandler.getValue();
            this.myType = SeleniumConfiguration.BROWSER_TYPE.enumOf(browserTypeStr);
            this.myBroserTypeXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase("SavePageSource")) {
            String savePageSource = this.mySavePageSourceXmlHandler.getValue();
            this.mySavePageSource = SeleniumInterfaceConfiguration.SAVE_SOURCE.enumOf(savePageSource);
            this.mySavePageSourceXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase("SaveScreenshot")) {
            String saveScreenshots = this.mySaveScreenShotXmlHandler.getValue();
            this.mySaveScreenShot = SeleniumInterfaceConfiguration.SAVE_SOURCE.enumOf(saveScreenshots);
            this.mySaveScreenShotXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(CUSTOMSTEP_DEFINITIONS_LINK_ELEMENT)) {
            String fileName = this.myCustomStepDefinitionsLinkXmlHandler.getValue();
            this.myCustomKeywordLinks.add(fileName);
            this.myCustomStepDefinitionsLinkXmlHandler.reset();
        } else {
            throw new Error("Child XML Handler returned, but not recognized. The handler was probably defined in the Constructor but not handled in handleReturnFromChildElement()");
        }
    }

    public SeleniumInterfaceConfiguration getConfiguration(String ifName) {
        return new SeleniumInterfaceConfiguration(ifName, this.myType, this.myBaseUrl, this.mySavePageSource, this.mySaveScreenShot, this.myCustomKeywordLinks);
    }

    public void reset() {
        this.myType = this.defaultType;
        this.myBaseUrl = this.defaultBaseUrl;
        this.mySavePageSource = this.defaultSavePageSource;
        this.mySaveScreenShot = this.defaultSaveScreenShot;
        this.myCustomKeywordLinks = new ArrayList();
    }
}

