/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.plugins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.testium.Testium;
import net.sf.testium.configuration.ConfigurationException;
import net.sf.testium.configuration.CustomStepDefinitionsXmlHandler;
import net.sf.testium.configuration.PersonalSeleniumConfigurationXmlHandler;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.configuration.SeleniumConfigurationXmlHandler;
import net.sf.testium.configuration.SeleniumInterfaceConfiguration;
import net.sf.testium.configuration.SeleniumInterfaceXmlHandler;
import net.sf.testium.executor.CustomInterface;
import net.sf.testium.executor.DefaultInterface;
import net.sf.testium.executor.SupportedInterfaceList;
import net.sf.testium.executor.TestStepCommandExecutor;
import net.sf.testium.executor.TestStepMetaExecutor;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.CheckListSize_modified;
import net.sf.testium.executor.webdriver.commands.GetListItem_modified;
import net.sf.testium.executor.webdriver.commands.GetListSize_modified;
import net.sf.testium.plugins.Plugin;
import net.sf.testium.plugins.PluginClassLoader;
import net.sf.testium.plugins.PluginCollection;
import net.sf.testium.systemundertest.SutInterface;
import org.testtoolinterfaces.testsuite.TestInterface;
import org.testtoolinterfaces.testsuite.TestInterfaceList;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.TTIException;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.XMLReader;

public class SeleniumPlugin
implements Plugin {
    public static final String BASEURL = "BaseUrl";

    public void loadPlugIn(PluginCollection aPluginCollection, RunTimeData anRtData) throws ConfigurationException {
        SupportedInterfaceList interfaceList = aPluginCollection.getInterfaces();
        TestStepMetaExecutor testStepMetaExecutor = aPluginCollection.getTestStepExecutor();
        SeleniumConfiguration config = this.readConfigFile(anRtData);
        File seleniumLibsDir = config.getSeleniumLibsDir();
        try {
            PluginClassLoader.addDirToClassLoader((File)seleniumLibsDir);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException((Throwable)e);
        }
        DefaultInterface defInterface = (DefaultInterface)interfaceList.getInterface("Default");
        defInterface.add((TestStepCommandExecutor)new CheckListSize_modified((SutInterface)defInterface));
        defInterface.add((TestStepCommandExecutor)new GetListItem_modified((SutInterface)defInterface));
        defInterface.add((TestStepCommandExecutor)new GetListSize_modified(defInterface));
        this.createInterfaces(anRtData, interfaceList, testStepMetaExecutor, config);
    }

    private void createInterfaces(RunTimeData anRtData, SupportedInterfaceList anInterfaceList, TestStepMetaExecutor aTestStepMetaExecutor, SeleniumConfiguration aConfig) throws ConfigurationException {
        for (String interfaceName : aConfig.getInterfaceNames()) {
            this.createInterface(anRtData, anInterfaceList, aTestStepMetaExecutor, aConfig, interfaceName);
        }
    }

    private void createInterface(RunTimeData anRtData, SupportedInterfaceList anInterfaceList, TestStepMetaExecutor aTestStepMetaExecutor, SeleniumConfiguration aConfig, String anInterfaceName) throws ConfigurationException {
        File configDir = (File)anRtData.getValue(Testium.CONFIGDIR);
        File interfaceDefinitionsFile = new File(configDir, anInterfaceName + ".xml");
        SeleniumInterfaceConfiguration tmpIfConfig = new SeleniumInterfaceConfiguration(anInterfaceName, aConfig.getBrowserType());
        SeleniumInterfaceConfiguration globalIfConfig = this.readInterfaceDefintions(interfaceDefinitionsFile, tmpIfConfig);
        File userConfigDir = (File)anRtData.getValue(Testium.USERCONFIGDIR);
        File personalInterfaceDefinitionsFile = new File(userConfigDir, anInterfaceName + ".xml");
        SeleniumInterfaceConfiguration ifConfig = globalIfConfig;
        if (personalInterfaceDefinitionsFile.canRead()) {
            ifConfig = this.readInterfaceDefintions(personalInterfaceDefinitionsFile, globalIfConfig);
        }
        ifConfig.setSeleniumGridUrl(aConfig.getSeleniumGridUrl());
        String sysPropBaseUrl = System.getProperty(anInterfaceName + "." + BASEURL);
        if (sysPropBaseUrl != null) {
            ifConfig.setBaseUrl(sysPropBaseUrl);
        }
        WebInterface iface = new WebInterface(anInterfaceName, anRtData, ifConfig);
        anInterfaceList.add((TestInterface)iface);
        this.createCustomKeywords(anRtData, anInterfaceList, aTestStepMetaExecutor, ifConfig, iface);
    }

    private void createCustomKeywords(RunTimeData anRtData, SupportedInterfaceList interfaceList, TestStepMetaExecutor testStepMetaExecutor, SeleniumInterfaceConfiguration ifConfig, WebInterface iface) throws ConfigurationException {
        for (String keywordsDefLink : ifConfig.getCustomKeywordLinks()) {
            String fileName = anRtData.substituteVars(keywordsDefLink);
            CustomStepDefinitionsXmlHandler.loadElementDefinitions((File)new File(fileName), (RunTimeData)anRtData, (CustomInterface)iface, (TestInterfaceList)interfaceList, (TestStepMetaExecutor)testStepMetaExecutor);
        }
    }

    private SeleniumInterfaceConfiguration readInterfaceDefintions(File interfaceDefinitionsFile, SeleniumInterfaceConfiguration tmpIfConfig) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("readInterfaceDefintions( " + tmpIfConfig.getInterfaceName() + " )"), (boolean)true);
        SeleniumInterfaceXmlHandler handler = null;
        try {
            XMLReader reader = XmlHandler.getNewXmlReader();
            handler = new SeleniumInterfaceXmlHandler(reader);
            handler.parse(reader, interfaceDefinitionsFile);
        }
        catch (TTIException e) {
            throw new ConfigurationException((Throwable)e);
        }
        SeleniumInterfaceConfiguration ifConfiguration = handler.getConfiguration(tmpIfConfig);
        handler.reset();
        return ifConfiguration;
    }

    public final SeleniumConfiguration readConfigFile(RunTimeData anRtData) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        File configDir = (File)anRtData.getValue(Testium.CONFIGDIR);
        File configFile = new File(configDir, "selenium.xml");
        SeleniumConfiguration config = this.readConfigFile(anRtData, configFile);
        SeleniumConfiguration.BROWSER_TYPE browserType = config.getBrowserType();
        URL gridUrl = config.getSeleniumGridUrl();
        File userConfigDir = (File)anRtData.getValue(Testium.USERCONFIGDIR);
        File userConfigFile = new File(userConfigDir, "selenium.xml");
        if (userConfigFile.exists()) {
            SeleniumConfiguration userConfig = this.readPersonalConfigFile(anRtData, userConfigFile);
            if (userConfig.getBrowserType() != null) {
                browserType = userConfig.getBrowserType();
            }
            if (userConfig.getSeleniumGridUrl() != null) {
                gridUrl = userConfig.getSeleniumGridUrl();
            }
        }
        return new SeleniumConfiguration(config.getInterfaceNames(), browserType, config.getSeleniumLibsDir(), gridUrl);
    }

    public final SeleniumConfiguration readConfigFile(RunTimeData anRtData, File aConfigFile) throws ConfigurationException {
        SeleniumConfigurationXmlHandler myHandler;
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("readConfigFile( " + aConfigFile.getName() + " )"), (boolean)true);
        try {
            XMLReader reader = XmlHandler.getNewXmlReader();
            myHandler = new SeleniumConfigurationXmlHandler(reader, anRtData);
            myHandler.parse(reader, aConfigFile);
        }
        catch (TTIException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        SeleniumConfiguration configuration = myHandler.getConfiguration();
        return configuration;
    }

    public final SeleniumConfiguration readPersonalConfigFile(RunTimeData anRtData, File aConfigFile) throws ConfigurationException {
        PersonalSeleniumConfigurationXmlHandler myHandler;
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("readConfigFile( " + aConfigFile.getName() + " )"), (boolean)true);
        try {
            XMLReader reader = XmlHandler.getNewXmlReader();
            myHandler = new PersonalSeleniumConfigurationXmlHandler(reader, anRtData);
            myHandler.parse(reader, aConfigFile);
        }
        catch (TTIException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        SeleniumConfiguration configuration = myHandler.getConfiguration();
        return configuration;
    }

    public static void loadElementDefinitions(File aFile, RunTimeData anRtData, CustomInterface anInterface, TestInterfaceList anInterfaceList, TestStepMetaExecutor aTestStepMetaExecutor) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("loadElementDefinitions( " + aFile.getName() + " )"), (boolean)true);
        CustomStepDefinitionsXmlHandler handler = null;
        try {
            XMLReader reader = XmlHandler.getNewXmlReader();
            handler = new CustomStepDefinitionsXmlHandler(reader, anRtData, anInterface, anInterfaceList, aTestStepMetaExecutor);
            handler.parse(reader, aFile);
        }
        catch (TTIException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
    }
}

