/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import com.google.common.base.Function;
import java.util.ArrayList;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.utils.RunTimeData;

public class WaitForUrl
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "waitForUrl";
    private static final String PAR_URL = "url";
    public static final SpecifiedParameter PARSPEC_URL = new SpecifiedParameter("url", String.class, false, true, true, false);
    private static final SpecifiedParameter PARSPEC_TIMEOUT = new SpecifiedParameter("timeout", Long.class, true, true, true, false).setDefaultValue((Object)5L);
    private static final SpecifiedParameter PARSPEC_SLEEPTIME = new SpecifiedParameter("sleeptime", Long.class, true, true, true, false).setDefaultValue((Object)500L);

    public WaitForUrl(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_URL);
        this.addParamSpec(PARSPEC_TIMEOUT);
        this.addParamSpec(PARSPEC_SLEEPTIME);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepCommandResult result) throws Exception {
        WebDriver webDriver = this.getDriver();
        String expectedUrl = (String)this.obtainValue(aVariables, parameters, PARSPEC_URL);
        Long timeout = (Long)this.obtainOptionalValue(aVariables, parameters, PARSPEC_TIMEOUT);
        Long sleeptime = (Long)this.obtainOptionalValue(aVariables, parameters, PARSPEC_SLEEPTIME);
        new WebDriverWait(webDriver, timeout.longValue(), sleeptime.longValue()).until((Function)new isExpectedUrl(expectedUrl));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class isExpectedUrl
    implements ExpectedCondition<Boolean> {
        String expectedUrl;

        public isExpectedUrl(String url) {
            this.expectedUrl = url;
        }

        public Boolean apply(WebDriver input) {
            String currentUrl = input.getCurrentUrl();
            return currentUrl.equalsIgnoreCase(this.expectedUrl);
        }
    }
}

