/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.util.ArrayList;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.openqa.selenium.WebDriver;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.utils.RunTimeData;

public class Get
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "get";
    private static final String PAR_URL = "url";
    private static final String PAR_RELATIVE = "relative";
    private static final String PAR_BROWSER = "browser";
    public static final SpecifiedParameter PARSPEC_URL = new SpecifiedParameter("url", String.class, false, true, true, false);
    public static final SpecifiedParameter PARSPEC_RELATIVE = new SpecifiedParameter("relative", Boolean.class, true, true, false, false).setDefaultValue((Object)false);
    public static final SpecifiedParameter PARSPEC_BROWSER = new SpecifiedParameter("browser", String.class, true, true, true, false).setDefaultValue((Object)"");

    public Get(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_URL);
        this.addParamSpec(PARSPEC_RELATIVE);
        this.addParamSpec(PARSPEC_BROWSER);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepCommandResult result) throws Exception {
        String url = (String)this.obtainValue(aVariables, parameters, PARSPEC_URL);
        result.setDisplayName(this.toString() + " " + url);
        Boolean relative = (Boolean)this.obtainOptionalValue(aVariables, parameters, PARSPEC_RELATIVE);
        if (relative.booleanValue()) {
            String baseUrl = this.getInterface().getBaseUrl();
            url = baseUrl + url;
        }
        SeleniumConfiguration.BROWSER_TYPE type = this.getBrowserType(aVariables, parameters);
        WebDriver webDriver = this.getDriver(type);
        webDriver.get(url);
    }

    private SeleniumConfiguration.BROWSER_TYPE getBrowserType(RunTimeData aVariables, ParameterArrayList parameters) throws Error, Exception {
        SeleniumConfiguration.BROWSER_TYPE type;
        Object typeObj = aVariables.getValue("browsertype");
        if (typeObj instanceof String) {
            type = SeleniumConfiguration.BROWSER_TYPE.enumOf((String)typeObj);
        } else if (typeObj instanceof SeleniumConfiguration.BROWSER_TYPE) {
            type = (SeleniumConfiguration.BROWSER_TYPE)((Object)typeObj);
        } else {
            throw new Error("browsertype is not set!");
        }
        String browserType = (String)this.obtainOptionalValue(aVariables, parameters, PARSPEC_BROWSER);
        if (!browserType.isEmpty()) {
            type = SeleniumConfiguration.BROWSER_TYPE.enumOf(browserType);
        }
        return type;
    }
}

