/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.configuration.SeleniumInterfaceConfiguration;
import net.sf.testium.executor.CustomInterface;
import net.sf.testium.executor.TestStepCommandExecutor;
import net.sf.testium.executor.webdriver.commands.Back;
import net.sf.testium.executor.webdriver.commands.CentralizeItem;
import net.sf.testium.executor.webdriver.commands.CheckAttribute;
import net.sf.testium.executor.webdriver.commands.CheckCurrentUrl;
import net.sf.testium.executor.webdriver.commands.CheckEditable;
import net.sf.testium.executor.webdriver.commands.CheckSelected;
import net.sf.testium.executor.webdriver.commands.CheckText;
import net.sf.testium.executor.webdriver.commands.CheckTitle;
import net.sf.testium.executor.webdriver.commands.Clear;
import net.sf.testium.executor.webdriver.commands.Click;
import net.sf.testium.executor.webdriver.commands.Close;
import net.sf.testium.executor.webdriver.commands.CtrlClick;
import net.sf.testium.executor.webdriver.commands.DefineElement;
import net.sf.testium.executor.webdriver.commands.DefineElementList;
import net.sf.testium.executor.webdriver.commands.ExecuteScript;
import net.sf.testium.executor.webdriver.commands.FindElement;
import net.sf.testium.executor.webdriver.commands.FindElements;
import net.sf.testium.executor.webdriver.commands.Forward;
import net.sf.testium.executor.webdriver.commands.Get;
import net.sf.testium.executor.webdriver.commands.GetAttribute;
import net.sf.testium.executor.webdriver.commands.GetCurrentUrl;
import net.sf.testium.executor.webdriver.commands.GetText;
import net.sf.testium.executor.webdriver.commands.GetTitle;
import net.sf.testium.executor.webdriver.commands.LoadElementDefinitions;
import net.sf.testium.executor.webdriver.commands.Quit;
import net.sf.testium.executor.webdriver.commands.Refresh;
import net.sf.testium.executor.webdriver.commands.SavePageSource;
import net.sf.testium.executor.webdriver.commands.SelectValue;
import net.sf.testium.executor.webdriver.commands.SendKeys;
import net.sf.testium.executor.webdriver.commands.SetByVariable;
import net.sf.testium.executor.webdriver.commands.Submit;
import net.sf.testium.executor.webdriver.commands.SwitchTo;
import net.sf.testium.executor.webdriver.commands.WaitFor;
import net.sf.testium.executor.webdriver.commands.WaitForPresent;
import net.sf.testium.executor.webdriver.commands.WaitForUrl;
import net.sf.testium.executor.webdriver.commands.WaitForVisible;
import net.sf.testium.selenium.FieldPublisher;
import net.sf.testium.selenium.WebDriverInterface;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.ParameterImpl;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.RunTimeVariable;
import org.testtoolinterfaces.utils.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebInterface
extends CustomInterface
implements FieldPublisher,
WebDriverInterface {
    private WebDriver myDriver;
    private final RunTimeData myRtData;
    private SeleniumInterfaceConfiguration config;

    public WebInterface(String aName, RunTimeData aRtData, SeleniumInterfaceConfiguration ifConfig) {
        super(aName);
        this.myRtData = aRtData;
        this.config = ifConfig;
        this.add((TestStepCommandExecutor)new Back(this));
        this.add((TestStepCommandExecutor)new CentralizeItem(this));
        this.add((TestStepCommandExecutor)new CheckAttribute(this));
        this.add((TestStepCommandExecutor)new CheckCurrentUrl(this));
        this.add((TestStepCommandExecutor)new CheckEditable(this));
        this.add((TestStepCommandExecutor)new CheckSelected(this));
        this.add((TestStepCommandExecutor)new CheckText(this));
        this.add((TestStepCommandExecutor)new CheckTitle(this));
        this.add((TestStepCommandExecutor)new Clear(this));
        this.add((TestStepCommandExecutor)new Click(this));
        this.add((TestStepCommandExecutor)new Close(this));
        this.add((TestStepCommandExecutor)new CtrlClick(this));
        this.add((TestStepCommandExecutor)new DefineElement(this));
        this.add((TestStepCommandExecutor)new DefineElementList(this));
        this.add((TestStepCommandExecutor)new ExecuteScript(this));
        this.add((TestStepCommandExecutor)new FindElement(this));
        this.add((TestStepCommandExecutor)new FindElements(this));
        this.add((TestStepCommandExecutor)new Forward(this));
        this.add((TestStepCommandExecutor)new Get(this));
        this.add((TestStepCommandExecutor)new GetAttribute(this));
        this.add((TestStepCommandExecutor)new GetCurrentUrl(this));
        this.add((TestStepCommandExecutor)new GetText(this));
        this.add((TestStepCommandExecutor)new GetTitle(this));
        this.add((TestStepCommandExecutor)new LoadElementDefinitions(this));
        this.add((TestStepCommandExecutor)new Quit(this));
        this.add((TestStepCommandExecutor)new Refresh(this));
        this.add((TestStepCommandExecutor)new SavePageSource(this));
        this.add((TestStepCommandExecutor)new SelectValue(this));
        this.add((TestStepCommandExecutor)new SendKeys(this));
        this.add((TestStepCommandExecutor)new SetByVariable(this));
        this.add((TestStepCommandExecutor)new Submit(this));
        this.add((TestStepCommandExecutor)new SwitchTo(this));
        this.add((TestStepCommandExecutor)new WaitFor(this));
        this.add((TestStepCommandExecutor)new WaitForPresent(this));
        this.add((TestStepCommandExecutor)new WaitForVisible(this));
        this.add((TestStepCommandExecutor)new WaitForUrl(this));
    }

    @Override
    public String getBaseUrl() {
        return this.config.getBaseUrl();
    }

    public WebDriver getDriver(SeleniumConfiguration.BROWSER_TYPE aType) {
        if (this.myDriver == null) {
            this.createDriver(aType);
        }
        return this.myDriver;
    }

    @Override
    public WebDriver getDriver() {
        return this.myDriver;
    }

    protected void setDriver(WebDriver aDriver) {
        this.myDriver = aDriver;
    }

    public void closeWindow(TestStepResult aTestStepResult) {
        if (this.myDriver == null) {
            return;
        }
        this.setTestStepResult(aTestStepResult);
        try {
            Set windowHandles = this.myDriver.getWindowHandles();
            int openWindows = windowHandles.size();
            this.myDriver.close();
            if (openWindows == 1) {
                this.setDriver(null);
            }
        }
        catch (UnreachableBrowserException ignored) {
            System.out.println("Issue #19: UnreachableBrowserException caught when quiting the browser.");
            this.setDriver(null);
        }
        catch (WebDriverException ignored) {
            System.out.println("Issue #19: WebDriverException caught when quiting the browser.");
            this.setDriver(null);
        }
        this.setTestStepResult(null);
    }

    public void quitDriver(TestStepResult aTestStepResult) {
        if (this.myDriver == null) {
            return;
        }
        this.setTestStepResult(aTestStepResult);
        try {
            this.myDriver.quit();
        }
        catch (UnreachableBrowserException ignored) {
            System.out.println("Issue #19: UnreachableBrowserException caught when quiting the browser.");
        }
        catch (WebDriverException ignored) {
            System.out.println("Issue #19: WebDriverException caught when quiting the browser.");
        }
        this.setTestStepResult(null);
        this.setDriver(null);
    }

    public void setTestStepResult(TestStepResult aTestStepResult) {
        if (this.myDriver == null) {
            return;
        }
    }

    protected void createDriver(SeleniumConfiguration.BROWSER_TYPE aType) {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        try {
            if (this.config.getSeleniumGridUrl() == null) {
                this.createLocalDriver(aType);
            } else {
                this.createRemoteDriver(aType);
            }
        }
        catch (WebDriverException e) {
            System.out.println("WebDriverException caught: " + e.getLocalizedMessage());
            throw new Error("Browser of type " + (Object)((Object)aType) + " is not found.\n" + e.getMessage());
        }
        catch (Exception ex) {
            System.out.println("Exception caught: " + ex.getLocalizedMessage());
        }
    }

    private void createRemoteDriver(SeleniumConfiguration.BROWSER_TYPE aType) {
        DesiredCapabilities capability = DesiredCapabilities.firefox();
        capability.setCapability("takesScreenshot", true);
        if (aType.equals((Object)SeleniumConfiguration.BROWSER_TYPE.CHROME)) {
            capability = DesiredCapabilities.chrome();
            capability.setCapability("takesScreenshot", true);
            ArrayList<String> switches = new ArrayList<String>();
            switches.add("disable-translate");
            capability.setCapability("chrome.switches", switches);
        } else if (aType.equals((Object)SeleniumConfiguration.BROWSER_TYPE.HTMLUNIT)) {
            capability = DesiredCapabilities.htmlUnit();
        } else if (aType.equals((Object)SeleniumConfiguration.BROWSER_TYPE.IE)) {
            capability = DesiredCapabilities.internetExplorer();
            capability.setCapability("takesScreenshot", true);
            String ignoreSecurityDomains = System.getProperty("webdriver.ie.ignoringsecuritydomains");
            capability.setCapability("ignoreProtectedModeSettings", (Object)new Boolean(ignoreSecurityDomains));
        }
        RemoteWebDriver driver = new RemoteWebDriver(this.config.getSeleniumGridUrl(), (Capabilities)capability);
        this.setDriver((WebDriver)driver);
    }

    private void createLocalDriver(SeleniumConfiguration.BROWSER_TYPE aType) {
        FirefoxDriver driver = new FirefoxDriver();
        if (aType.equals((Object)SeleniumConfiguration.BROWSER_TYPE.CHROME)) {
            DesiredCapabilities capabilities = DesiredCapabilities.chrome();
            ArrayList<String> switches = new ArrayList<String>();
            switches.add("disable-translate");
            capabilities.setCapability("chrome.switches", switches);
            driver = new ChromeDriver((Capabilities)capabilities);
        } else if (aType.equals((Object)SeleniumConfiguration.BROWSER_TYPE.HTMLUNIT)) {
            driver = new HtmlUnitDriver();
        } else if (aType.equals((Object)SeleniumConfiguration.BROWSER_TYPE.IE)) {
            DesiredCapabilities capabilities = DesiredCapabilities.internetExplorer();
            String ignoreSecurityDomains = System.getProperty("webdriver.ie.ignoringsecuritydomains");
            capabilities.setCapability("ignoreProtectedModeSettings", (Object)new Boolean(ignoreSecurityDomains));
            driver = new InternetExplorerDriver((Capabilities)capabilities);
        }
        this.setDriver((WebDriver)driver);
    }

    public ParameterImpl createParameter(String aName, String aType, String aValue) throws TestSuiteException {
        try {
            return super.createParameter(aName, aType, aValue);
        }
        catch (TestSuiteException ignored) {
            By by = WebInterface.getBy(aType, aValue);
            if (by != null) {
                return new ParameterImpl(aName, (Object)by);
            }
            throw new TestSuiteException("Parameter type " + aType + " is not supported for interface " + this.getInterfaceName(), aName);
        }
    }

    @Override
    public void addElement(String varName, WebElement element) {
        if (element == null) {
            return;
        }
        RunTimeVariable rtVar = new RunTimeVariable(varName, (Object)element);
        this.myRtData.add(rtVar);
    }

    @Override
    public void addElement(String varName, List<WebElement> elements) {
        if (elements == null) {
            return;
        }
        RunTimeVariable rtVar = new RunTimeVariable(varName, elements);
        this.myRtData.add(rtVar);
    }

    @Override
    public WebElement getElement(String varName) {
        WebElement element = (WebElement)this.myRtData.getValueAs(WebElement.class, varName);
        return element;
    }

    public String toString() {
        return this.getInterfaceName();
    }

    public void destroy() {
        if (this.myDriver == null) {
            return;
        }
        this.myDriver.quit();
        this.setDriver(null);
    }

    public static By getBy(String aType, String aValue) {
        if (aType.equalsIgnoreCase("id")) {
            return By.id((String)aValue);
        }
        if (aType.equalsIgnoreCase("name")) {
            return By.name((String)aValue);
        }
        if (aType.equalsIgnoreCase("linktext")) {
            return By.linkText((String)aValue);
        }
        if (aType.equalsIgnoreCase("partiallinktext")) {
            return By.partialLinkText((String)aValue);
        }
        if (aType.equalsIgnoreCase("tagname")) {
            return By.tagName((String)aValue);
        }
        if (aType.equalsIgnoreCase("xpath")) {
            return By.xpath((String)aValue);
        }
        if (aType.equalsIgnoreCase("classname")) {
            return By.className((String)aValue);
        }
        if (aType.equalsIgnoreCase("cssselector")) {
            return By.cssSelector((String)aValue);
        }
        return null;
    }
}

