/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.util.ArrayList;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;

public class SendKeys
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "sendKeys";
    private static final String PAR_ELEMENT = "element";
    private static final String PAR_KEYS = "keys";
    private static final String PAR_SPECIAL_KEY = "specialKey";
    private static final SpecifiedParameter PARSPEC_ELEMENT = new SpecifiedParameter("element", WebElement.class, false, false, true, false);
    private static final SpecifiedParameter PARSPEC_KEYS = new SpecifiedParameter("keys", String.class, true, true, true, true);
    private static final SpecifiedParameter PARSPEC_SPECIAL_KEY = new SpecifiedParameter("specialKey", String.class, true, true, true, false);

    public SendKeys(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_ELEMENT);
        this.addParamSpec(PARSPEC_KEYS);
        this.addParamSpec(PARSPEC_SPECIAL_KEY);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepCommandResult result) throws Exception {
        WebElement element = this.obtainElement(aVariables, parameters, PARSPEC_ELEMENT);
        Object keysToSendObj = this.obtainValue(aVariables, parameters, PARSPEC_KEYS);
        if (keysToSendObj instanceof String) {
            String keysToSend = (String)keysToSendObj;
            element.sendKeys(new CharSequence[]{keysToSend});
            return;
        }
        Object keysToSendSpecialObj = this.obtainValue(aVariables, parameters, PARSPEC_SPECIAL_KEY);
        if (keysToSendSpecialObj instanceof String) {
            Keys keysToSendSpecial = Keys.valueOf((String)((String)keysToSendSpecialObj));
            element.sendKeys(new CharSequence[]{keysToSendSpecial});
            return;
        }
        throw new TestSuiteException("One of parameters keys and specialKey must be set.", this.toString());
    }
}

