/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.configuration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.sf.testium.Testium;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.configuration.SeleniumInterfacesXmlHandler;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.RunTimeVariable;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class SeleniumConfigurationXmlHandler
extends XmlHandler {
    private static final String START_ELEMENT = "SeleniumConfiguration";
    private static final String DEF_BROWSER_ELEMENT = "DefaultBrowser";
    private static final String IE_IGNORING_SECURITY_DOMAINS_ELEMENT = "IeIntroduceFlakinessByIgnoringSecurityDomains";
    private static final String IE_PATH_TO_DRIVER_SERVER_ELEMENT = "IePathToDriverServer";
    public static final String SAVE_PAGESOURCE = "SavePageSource";
    public static final String SAVE_SCREENSHOT = "SaveScreenshot";
    private static final String SELENIUM_LIBS_DIR_ELEMENT = "SeleniumLibsDir";
    private static final String SELENIUM_GRID_URL_ELEMENT = "SeleniumGridUrl";
    private static final String CHROME_DRIVER_ELEMENT = "ChromeDriver";
    private GenericTagAndStringXmlHandler myDefaultBrowserXmlHandler;
    private GenericTagAndStringXmlHandler mySeleniumLibsDirXmlHandler;
    private GenericTagAndStringXmlHandler myChromeDriverXmlHandler;
    private GenericTagAndStringXmlHandler mySavePageSourceXmlHandler;
    private GenericTagAndStringXmlHandler mySaveScreenShotXmlHandler;
    private GenericTagAndStringXmlHandler myIeIgnoreSecurityDomainsXmlHandler;
    private GenericTagAndStringXmlHandler myIePathToDriverServerXmlHandler;
    private GenericTagAndStringXmlHandler mySeleniumGridUrlXmlHandler;
    private SeleniumInterfacesXmlHandler myInterfacesXmlHandler;
    private SeleniumConfiguration.BROWSER_TYPE myDefaultBrowser = SeleniumConfiguration.BROWSER_TYPE.HTMLUNIT;
    private File mySeleniumLibsDir;
    private URL mySeleniumGridUrl;
    private ArrayList<String> myInterfaceNames;
    private RunTimeData myRtData;

    public SeleniumConfigurationXmlHandler(XMLReader anXmlReader, RunTimeData anRtData) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        File pluginsDir = anRtData.getValueAsFile(Testium.PLUGINSDIR);
        this.mySeleniumLibsDir = new File(pluginsDir, "SeleniumLibs");
        this.mySeleniumGridUrl = null;
        File baseDir = anRtData.getValueAsFile(Testium.BASEDIR);
        File dataDir = new File(baseDir, "../../src/data");
        SeleniumConfiguration.setChromeDriver(new File(dataDir, "chromedriver.exe"));
        SeleniumConfiguration.setIeDriver(new File(dataDir, "IEDriverServer.exe"));
        SeleniumConfiguration.setIeIgnoreSecurityDomains(false);
        this.myRtData = anRtData;
        this.myDefaultBrowserXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, DEF_BROWSER_ELEMENT);
        this.addElementHandler((XmlHandler)this.myDefaultBrowserXmlHandler);
        this.mySeleniumLibsDirXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, SELENIUM_LIBS_DIR_ELEMENT);
        this.addElementHandler((XmlHandler)this.mySeleniumLibsDirXmlHandler);
        this.mySeleniumGridUrlXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, SELENIUM_GRID_URL_ELEMENT);
        this.addElementHandler((XmlHandler)this.mySeleniumGridUrlXmlHandler);
        this.myChromeDriverXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, CHROME_DRIVER_ELEMENT);
        this.addElementHandler((XmlHandler)this.myChromeDriverXmlHandler);
        this.myIeIgnoreSecurityDomainsXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, IE_IGNORING_SECURITY_DOMAINS_ELEMENT);
        this.addElementHandler((XmlHandler)this.myIeIgnoreSecurityDomainsXmlHandler);
        this.myIePathToDriverServerXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, IE_PATH_TO_DRIVER_SERVER_ELEMENT);
        this.addElementHandler((XmlHandler)this.myIePathToDriverServerXmlHandler);
        this.mySavePageSourceXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, SAVE_PAGESOURCE);
        this.addElementHandler((XmlHandler)this.mySavePageSourceXmlHandler);
        RunTimeVariable savePagesourceVar = new RunTimeVariable("savePageSource", (Object)"NEVER");
        this.myRtData.add(savePagesourceVar);
        this.mySaveScreenShotXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, SAVE_SCREENSHOT);
        this.addElementHandler((XmlHandler)this.mySaveScreenShotXmlHandler);
        RunTimeVariable saveScreenshotsVar = new RunTimeVariable("saveScreenShot", (Object)"NEVER");
        this.myRtData.add(saveScreenshotsVar);
        this.myInterfacesXmlHandler = new SeleniumInterfacesXmlHandler(anXmlReader);
        this.addElementHandler(this.myInterfacesXmlHandler);
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) throws TestSuiteException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("handleReturnFromChildElement( " + aQualifiedName + " )"), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase(DEF_BROWSER_ELEMENT)) {
            SeleniumConfiguration.BROWSER_TYPE browserType = SeleniumConfiguration.BROWSER_TYPE.enumOf(this.myDefaultBrowserXmlHandler.getValue());
            RunTimeVariable browserTypeVar = new RunTimeVariable("browsertype", (Object)browserType);
            this.myRtData.add(browserTypeVar);
            this.myDefaultBrowser = browserType;
            this.myDefaultBrowserXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(SELENIUM_LIBS_DIR_ELEMENT)) {
            String seleniumLibsDirName = this.mySeleniumLibsDirXmlHandler.getValue();
            seleniumLibsDirName = this.myRtData.substituteVars(seleniumLibsDirName);
            this.mySeleniumLibsDir = new File(seleniumLibsDirName);
            this.mySeleniumLibsDirXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(SELENIUM_GRID_URL_ELEMENT)) {
            String seleniumGridUrl = this.mySeleniumGridUrlXmlHandler.getValue();
            seleniumGridUrl = this.myRtData.substituteVars(seleniumGridUrl);
            try {
                this.mySeleniumGridUrl = new URL(seleniumGridUrl);
            }
            catch (MalformedURLException e) {
                throw new TestSuiteException("\"SeleniumGridUrl\" is malformed: " + e.getMessage(), (Exception)e);
            }
            this.mySeleniumGridUrlXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(CHROME_DRIVER_ELEMENT)) {
            String chromeDriverName = this.myChromeDriverXmlHandler.getValue();
            chromeDriverName = this.myRtData.substituteVars(chromeDriverName);
            SeleniumConfiguration.setChromeDriver(new File(chromeDriverName));
            this.myChromeDriverXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(IE_IGNORING_SECURITY_DOMAINS_ELEMENT)) {
            String ignoreSecurityDomainsFlag = this.myIeIgnoreSecurityDomainsXmlHandler.getValue();
            SeleniumConfiguration.setIeIgnoreSecurityDomains(new Boolean(ignoreSecurityDomainsFlag));
            this.myIeIgnoreSecurityDomainsXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(IE_PATH_TO_DRIVER_SERVER_ELEMENT)) {
            String ieDriverName = this.myIePathToDriverServerXmlHandler.getValue();
            ieDriverName = this.myRtData.substituteVars(ieDriverName);
            SeleniumConfiguration.setIeDriver(new File(ieDriverName));
            this.myIePathToDriverServerXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(SAVE_PAGESOURCE)) {
            String savePageSource = this.mySavePageSourceXmlHandler.getValue();
            if (!(savePageSource.equalsIgnoreCase("NEVER") || savePageSource.equalsIgnoreCase("ONFAIL") || savePageSource.equalsIgnoreCase("ALWAYS"))) {
                throw new TestSuiteException("\"" + savePageSource + "\" is not allowed for " + SAVE_PAGESOURCE + ". Only NEVER, ONFAIL, or ALWAYS");
            }
            RunTimeVariable savePageSourceVar = new RunTimeVariable("savePageSource", (Object)savePageSource.toUpperCase());
            this.myRtData.add(savePageSourceVar);
            this.mySavePageSourceXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(SAVE_SCREENSHOT)) {
            String saveScreenshots = this.mySaveScreenShotXmlHandler.getValue();
            if (!(saveScreenshots.equalsIgnoreCase("NEVER") || saveScreenshots.equalsIgnoreCase("ONFAIL") || saveScreenshots.equalsIgnoreCase("ALWAYS"))) {
                throw new TestSuiteException("\"" + saveScreenshots + "\" is not allowed for " + SAVE_SCREENSHOT + ". Only NEVER, ONFAIL, or ALWAYS");
            }
            RunTimeVariable saveScreenshotsVar = new RunTimeVariable("saveScreenShot", (Object)saveScreenshots.toUpperCase());
            this.myRtData.add(saveScreenshotsVar);
            this.mySaveScreenShotXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(this.myInterfacesXmlHandler.getStartElement())) {
            this.myInterfaceNames = this.myInterfacesXmlHandler.getInterfaceNames();
            this.myInterfacesXmlHandler.reset();
        } else {
            throw new Error("Child XML Handler returned, but not recognized. The handler was probably defined in the Constructor but not handled in handleReturnFromChildElement()");
        }
    }

    public SeleniumConfiguration getConfiguration() {
        return new SeleniumConfiguration(this.myInterfaceNames, this.myDefaultBrowser, this.mySeleniumLibsDir, this.mySeleniumGridUrl);
    }
}

