/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.configuration;

import net.sf.testium.configuration.ByXmlHandler;
import net.sf.testium.configuration.ConfigurationException;
import net.sf.testium.selenium.SimplePageElement;
import net.sf.testium.selenium.WebDriverInterface;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.RunTimeVariable;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class DefineElementXmlHandler
extends XmlHandler {
    private static final String START_ELEMENT = "DefineElement";
    private static final String NAME_ELEMENT = "Name";
    private static final String BASE_ELEMENT_ELEMENT = "BaseElement";
    private static final String FRAME_ELEMENT = "Frame";
    private ByXmlHandler myByXmlHandler;
    private GenericTagAndStringXmlHandler myNameXmlHandler;
    private GenericTagAndStringXmlHandler myBaseElementXmlHandler;
    private GenericTagAndStringXmlHandler myFrameXmlHandler;
    private final RunTimeData myRtData;
    private final WebDriverInterface myInterface;
    private By myBy;
    private String myName;
    private WebElement myBaseElement;
    private WebElement myFrame;

    public DefineElementXmlHandler(XMLReader anXmlReader, RunTimeData anRtData, WebDriverInterface anInterface) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.myRtData = anRtData;
        this.myInterface = anInterface;
        this.myByXmlHandler = new ByXmlHandler(anXmlReader);
        this.addElementHandler(this.myByXmlHandler);
        this.myNameXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, NAME_ELEMENT);
        this.addElementHandler((XmlHandler)this.myNameXmlHandler);
        this.myBaseElementXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, BASE_ELEMENT_ELEMENT);
        this.addElementHandler((XmlHandler)this.myBaseElementXmlHandler);
        this.myFrameXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, FRAME_ELEMENT);
        this.addElementHandler((XmlHandler)this.myFrameXmlHandler);
        this.reset();
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) throws TestSuiteException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("handleReturnFromChildElement( " + aQualifiedName + " )"), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase("By")) {
            this.myBy = this.myByXmlHandler.getBy();
            this.myByXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(NAME_ELEMENT)) {
            this.myName = this.myNameXmlHandler.getValue();
            this.myNameXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(BASE_ELEMENT_ELEMENT)) {
            String baseElementName = this.myBaseElementXmlHandler.getValue();
            this.myBaseElement = (WebElement)this.myRtData.getValueAs(WebElement.class, baseElementName);
            this.myBaseElementXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(FRAME_ELEMENT)) {
            String frameElementName = this.myFrameXmlHandler.getValue();
            this.myFrame = (WebElement)this.myRtData.getValueAs(WebElement.class, frameElementName);
            this.myFrameXmlHandler.reset();
        } else {
            throw new Error("Child XML Handler returned, but not recognized. The handler was probably defined in the Constructor but not handled in handleReturnFromChildElement()");
        }
    }

    public void defineElement() throws ConfigurationException {
        if (this.myName.isEmpty()) {
            throw new ConfigurationException("Name of element is not specified");
        }
        if (this.myBy == null) {
            throw new ConfigurationException("By is not defined for " + this.myName);
        }
        SimplePageElement elm = new SimplePageElement(this.myBy, this.myInterface, null, this.myBaseElement);
        if (this.myFrame != null) {
            elm.setFrame(this.myFrame);
        }
        RunTimeVariable elementVar = new RunTimeVariable(this.myName, (Object)elm);
        this.myRtData.add(elementVar);
    }

    public void reset() {
        this.myBy = null;
        this.myName = "";
        this.myBaseElement = null;
        this.myFrame = null;
    }
}

