/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.executor.general.GenericCommandExecutor;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.systemundertest.SutInterface;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testresult.impl.TestStepCommandResultImpl;
import org.testtoolinterfaces.testsuite.Parameter;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.ParameterImpl;
import org.testtoolinterfaces.testsuite.TestStepCommand;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericSeleniumCommandExecutor
extends GenericCommandExecutor {
    private String mySavePageSource = "NEVER";
    private String mySaveScreenshot = "NEVER";

    protected abstract void doExecute(RunTimeData var1, ParameterArrayList var2, TestStepCommandResult var3) throws Exception;

    public GenericSeleniumCommandExecutor(String command, WebInterface aWebInterface, ArrayList<SpecifiedParameter> parameterSpecs) {
        super(command, (SutInterface)aWebInterface, parameterSpecs);
    }

    protected WebInterface getInterface() {
        return (WebInterface)super.getInterface();
    }

    protected WebDriver getDriver() {
        return this.getInterface().getDriver();
    }

    protected WebDriver getDriver(SeleniumConfiguration.BROWSER_TYPE aBrowserType) {
        WebDriver webDriver = this.getInterface().getDriver(aBrowserType);
        return webDriver;
    }

    @Deprecated
    protected WebDriver getDriverAndSetResult(TestStepResult aTestStepResult, SeleniumConfiguration.BROWSER_TYPE aBrowserType) {
        WebDriver webDriver = this.getInterface().getDriver(aBrowserType);
        return webDriver;
    }

    public TestStepResult execute(TestStepCommand aStep, RunTimeData aVariables, File aLogDir) throws TestSuiteException {
        ParameterArrayList parameters = aStep.getParameters();
        this.verifyParameters(parameters);
        TestStepCommandResultImpl result = new TestStepCommandResultImpl(aStep);
        this.mySavePageSource = aVariables.getValueAsString("savePageSource");
        this.mySaveScreenshot = aVariables.getValueAsString("saveScreenShot");
        try {
            this.doExecute(aVariables, parameters, (TestStepCommandResult)result);
            result.setResult(TestResult.VERDICT.PASSED);
        }
        catch (UnreachableBrowserException e) {
            System.out.println("Issue #19: UnreachableBrowserException caught when executing command: " + this.getCommand());
            this.getInterface().destroy();
            this.failTest(aLogDir, (TestStepResult)result, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.failTest(aLogDir, (TestStepResult)result, e);
        }
        if (this.mySavePageSource.equalsIgnoreCase("ALWAYS")) {
            this.savePageSource(aLogDir, (TestStepResult)result);
        }
        if (this.mySaveScreenshot.equalsIgnoreCase("ALWAYS")) {
            this.saveScreenShot(aLogDir, (TestStepResult)result);
        }
        return result;
    }

    protected void failTest(File aLogDir, TestStepResult aResult, String aMessage) {
        aResult.setResult(TestResult.VERDICT.FAILED);
        if (!aMessage.isEmpty()) {
            aResult.addComment(aMessage);
        }
        if (this.mySavePageSource.equalsIgnoreCase("ONFAIL") || this.mySavePageSource.equalsIgnoreCase("ALWAYS")) {
            this.savePageSource(aLogDir, aResult);
        }
        if (this.mySaveScreenshot.equalsIgnoreCase("ONFAIL") || this.mySaveScreenshot.equalsIgnoreCase("ALWAYS")) {
            this.saveScreenShot(aLogDir, aResult);
        }
    }

    public void savePageSource(File aLogDir, TestStepResult aResult) {
        try {
            WebDriver driver = this.getDriver();
            if (driver instanceof RemoteWebDriver) {
                RemoteWebDriver remDriver = (RemoteWebDriver)driver;
                String pageSource = remDriver.getPageSource();
                int i = 0;
                String sourceLogKey = "source";
                File sourceLog = new File(aLogDir, this.fileNameBase() + sourceLogKey + ".html");
                while (sourceLog.exists() && ++i < 100) {
                    sourceLog = new File(aLogDir, this.fileNameBase() + sourceLogKey + "_" + i + ".html");
                }
                FileOutputStream sourceLogOS = new FileOutputStream(sourceLog.getAbsolutePath());
                PrintWriter pw = new PrintWriter(sourceLogOS);
                pw.println(pageSource);
                pw.flush();
                aResult.addTestLog(sourceLogKey, sourceLog.getPath());
            }
        }
        catch (Throwable t) {
            aResult.addComment("Source file could not be saved: " + t.getMessage());
            Trace.print((Trace.LEVEL)Trace.SUITE, (Throwable)t);
        }
    }

    public void saveScreenShot(File aLogDir, TestStepResult aResult) {
        try {
            WebDriver driver = this.getDriver();
            if (driver != null && driver.getClass().equals(RemoteWebDriver.class)) {
                driver = new Augmenter().augment(driver);
            }
            if (driver instanceof RemoteWebDriver) {
                TakesScreenshot screenShotDriver = (TakesScreenshot)driver;
                File tmpScreenFile = (File)screenShotDriver.getScreenshotAs(OutputType.FILE);
                int i = 0;
                String screenFileKey = "screen";
                File screenFile = new File(aLogDir, this.fileNameBase() + screenFileKey + ".png");
                while (screenFile.exists() && ++i < 100) {
                    screenFile = new File(aLogDir, this.fileNameBase() + screenFileKey + "_" + i + ".png");
                }
                FileUtils.moveFile((File)tmpScreenFile, (File)screenFile);
                aResult.addTestLog(screenFileKey, screenFile.getPath());
            }
        }
        catch (Throwable t) {
            aResult.addComment("Screen file could not be saved: " + t.getMessage());
            Trace.print((Trace.LEVEL)Trace.SUITE, (Throwable)t);
        }
    }

    private String fileNameBase() {
        return this.getCommand() + "_";
    }

    public boolean verifyParameters(ParameterArrayList aParameters) throws TestSuiteException {
        Iterator paramSpecItr = this.getParametersIterator();
        while (paramSpecItr.hasNext()) {
            SpecifiedParameter paramSpec = (SpecifiedParameter)paramSpecItr.next();
            Parameter par = aParameters.get(paramSpec.getName());
            if (!this.verifyParameterExists(par, paramSpec)) continue;
            if (paramSpec.getType().equals(By.class)) {
                this.verifyBy(par, paramSpec);
                continue;
            }
            this.verifyValueOrVariable(par, paramSpec);
        }
        return true;
    }

    protected void verifyBy(Parameter par, SpecifiedParameter paramSpec) throws TestSuiteException {
        ParameterImpl valuePar;
        if (par instanceof ParameterImpl && !By.class.isAssignableFrom((valuePar = (ParameterImpl)par).getValueType())) {
            throw new TestSuiteException("Parameter " + paramSpec.getName() + " must be of type 'id', 'name'," + " 'linkText', 'partialLinkText', 'tagName', 'xPath'," + " 'className', or 'cssSelector'", this.toString());
        }
    }

    protected WebElement obtainElement(RunTimeData aVariables, ParameterArrayList parameters, SpecifiedParameter paramSpec) throws Exception {
        WebElement element = (WebElement)super.obtainValue(aVariables, parameters, paramSpec);
        if (element == null) {
            if (paramSpec.isOptional()) {
                return null;
            }
            throw new Exception("Mandatory element was not found or was not a WebElement: " + paramSpec.getName());
        }
        return element;
    }
}

