/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.util.ArrayList;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.CheckText;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.openqa.selenium.WebElement;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.RunTimeVariable;

public class GetText
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "getText";
    private static final String PAR_ELEMENT = "element";
    private static final String PAR_VARIABLE = "variable";
    private static final SpecifiedParameter PARSPEC_ELEMENT = new SpecifiedParameter("element", WebElement.class, false, false, true, false);
    public static final SpecifiedParameter PARSPEC_VARIABLE = new SpecifiedParameter("variable", String.class, false, true, false, false);

    public GetText(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_ELEMENT);
        this.addParamSpec(PARSPEC_VARIABLE);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepCommandResult result) throws Exception {
        WebElement element = this.obtainElement(aVariables, parameters, PARSPEC_ELEMENT);
        String varName = (String)this.obtainValue(aVariables, parameters, PARSPEC_VARIABLE);
        String text = CheckText.getActualText(element);
        result.setDisplayName(this.toString() + " " + varName + "=\"" + text + "\"");
        RunTimeVariable rtVariable = new RunTimeVariable(varName, (Object)text);
        aVariables.add(rtVariable);
    }
}

