/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.configuration;

import java.util.ArrayList;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.configuration.SeleniumInterfaceConfiguration;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.TTIException;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class SeleniumInterfaceXmlHandler
extends XmlHandler {
    public static final String START_ELEMENT = "SeleniumInterface";
    private static final String BROWSER_TYPE_ELEMENT = "BrowserType";
    private static final String BASE_URL_ELEMENT = "BaseUrl";
    private static final String CUSTOMSTEP_DEFINITIONS_LINK_ELEMENT = "CustomStepDefinitionsLink";
    private GenericTagAndStringXmlHandler myBaseUrlXmlHandler;
    private GenericTagAndStringXmlHandler myBroserTypeXmlHandler;
    private GenericTagAndStringXmlHandler myCustomStepDefinitionsLinkXmlHandler;
    private GenericTagAndStringXmlHandler mySavePageSourceXmlHandler;
    private GenericTagAndStringXmlHandler mySaveScreenShotXmlHandler;
    private String myType;
    private String myBaseUrl;
    private String mySavePageSource;
    private String mySaveScreenShot;
    private ArrayList<String> myCustomKeywordLinks;

    public SeleniumInterfaceXmlHandler(XMLReader anXmlReader) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.reset();
        this.myBaseUrlXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, BASE_URL_ELEMENT);
        this.addElementHandler((XmlHandler)this.myBaseUrlXmlHandler);
        this.myBroserTypeXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, BROWSER_TYPE_ELEMENT);
        this.addElementHandler((XmlHandler)this.myBroserTypeXmlHandler);
        this.myCustomStepDefinitionsLinkXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, CUSTOMSTEP_DEFINITIONS_LINK_ELEMENT);
        this.addElementHandler((XmlHandler)this.myCustomStepDefinitionsLinkXmlHandler);
        this.mySavePageSourceXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, "SavePageSource");
        this.addElementHandler((XmlHandler)this.mySavePageSourceXmlHandler);
        this.mySaveScreenShotXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, "SaveScreenshot");
        this.addElementHandler((XmlHandler)this.mySaveScreenShotXmlHandler);
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) throws TTIException {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) throws TTIException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("handleReturnFromChildElement( " + aQualifiedName + " )"), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase(BASE_URL_ELEMENT)) {
            this.myBaseUrl = this.myBaseUrlXmlHandler.getValue();
            this.myBaseUrlXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(BROWSER_TYPE_ELEMENT)) {
            this.myType = this.myBaseUrlXmlHandler.getValue();
            this.myBaseUrlXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase("SavePageSource")) {
            String savePageSource = this.mySavePageSourceXmlHandler.getValue();
            if (!(savePageSource.equalsIgnoreCase("NEVER") || savePageSource.equalsIgnoreCase("ONFAIL") || savePageSource.equalsIgnoreCase("ALWAYS"))) {
                throw new TestSuiteException("\"" + savePageSource + "\" is not allowed for " + "SavePageSource" + ". Only NEVER, ONFAIL, or ALWAYS");
            }
            this.mySavePageSource = savePageSource.toUpperCase();
            this.mySavePageSourceXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase("SaveScreenshot")) {
            String saveScreenshots = this.mySaveScreenShotXmlHandler.getValue();
            if (!(saveScreenshots.equalsIgnoreCase("NEVER") || saveScreenshots.equalsIgnoreCase("ONFAIL") || saveScreenshots.equalsIgnoreCase("ALWAYS"))) {
                throw new TestSuiteException("\"" + saveScreenshots + "\" is not allowed for " + "SaveScreenshot" + ". Only NEVER, ONFAIL, or ALWAYS");
            }
            this.mySaveScreenShot = saveScreenshots.toUpperCase();
            this.mySaveScreenShotXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(CUSTOMSTEP_DEFINITIONS_LINK_ELEMENT)) {
            String fileName = this.myCustomStepDefinitionsLinkXmlHandler.getValue();
            this.myCustomKeywordLinks.add(fileName);
            this.myCustomStepDefinitionsLinkXmlHandler.reset();
        } else {
            throw new Error("Child XML Handler returned, but not recognized. The handler was probably defined in the Constructor but not handled in handleReturnFromChildElement()");
        }
    }

    public SeleniumInterfaceConfiguration getConfiguration(SeleniumInterfaceConfiguration config) {
        if (!this.myType.isEmpty()) {
            config.setType(SeleniumConfiguration.BROWSER_TYPE.enumOf(this.myType));
        }
        if (!this.myBaseUrl.isEmpty()) {
            config.setBaseUrl(this.myBaseUrl);
        }
        if (!this.mySavePageSource.isEmpty()) {
            config.setSavePageSource(new Boolean(this.mySavePageSource));
        }
        if (!this.mySaveScreenShot.isEmpty()) {
            config.setSavePageSource(new Boolean(this.mySaveScreenShot));
        }
        ArrayList<String> customKeywordLinks = config.getCustomKeywordLinks();
        for (String keywordsDefLink : this.myCustomKeywordLinks) {
            if (customKeywordLinks.contains(keywordsDefLink)) continue;
            customKeywordLinks.add(keywordsDefLink);
        }
        config.setCustomKeywordLinks(customKeywordLinks);
        return config;
    }

    public void reset() {
        this.myType = "";
        this.myBaseUrl = "";
        this.mySavePageSource = "";
        this.mySaveScreenShot = "";
        this.myCustomKeywordLinks = new ArrayList();
    }
}

