/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.util.ArrayList;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.openqa.selenium.WebElement;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.utils.RunTimeData;

public class CheckText
extends GenericSeleniumCommandExecutor {
    private static final SpecifiedParameter PARSPEC_ELEMENT = new SpecifiedParameter("element", WebElement.class, false, false, true, false);
    private static final SpecifiedParameter PARSPEC_EXPECTED = new SpecifiedParameter("expected", String.class, false, true, true, true);
    private static final SpecifiedParameter PARSPEC_MATCH = new SpecifiedParameter("match", String.class, true, true, false, false).setDefaultValue((Object)"exact");
    private static final SpecifiedParameter PARSPEC_CASE = new SpecifiedParameter("case", Boolean.class, true, true, false, false).setDefaultValue((Object)true);
    private static final String COMMAND = "checkText";

    public CheckText(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_ELEMENT);
        this.addParamSpec(PARSPEC_EXPECTED);
        this.addParamSpec(PARSPEC_MATCH);
        this.addParamSpec(PARSPEC_CASE);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepResult result) throws Exception {
        WebElement element = this.obtainElement(aVariables, parameters, PARSPEC_ELEMENT);
        String expectedText = (String)this.obtainValue(aVariables, parameters, PARSPEC_EXPECTED);
        String actualText = CheckText.getActualText(element);
        String match = (String)this.obtainOptionalValue(aVariables, parameters, PARSPEC_MATCH);
        boolean caseSensitive = (Boolean)this.obtainOptionalValue(aVariables, parameters, PARSPEC_CASE);
        if (match.equalsIgnoreCase("exact")) {
            this.checkExact(expectedText, actualText, caseSensitive, "Actual Text: \"" + actualText + "\" is not equal to: \"" + expectedText + "\"");
            return;
        }
        if (match.equalsIgnoreCase("contains")) {
            this.checkContains(expectedText, actualText, caseSensitive, "Actual Text: \"" + actualText + "\" does not contain: \"" + expectedText + "\"");
            return;
        }
        if (match.equalsIgnoreCase("startsWith")) {
            this.checkStartsWith(expectedText, actualText, caseSensitive, "Actual Text: \"" + actualText + "\" does not start with: \"" + expectedText + "\"");
            return;
        }
        if (match.equalsIgnoreCase("endsWith")) {
            this.checkEndsWith(expectedText, actualText, caseSensitive, "Actual Text: \"" + actualText + "\" does not end with: \"" + expectedText + "\"");
            return;
        }
        throw new Exception("match criteria \"" + match + "\" is not supported. Only exact, contains, startsWith, or endsWith");
    }

    private void checkExact(String expectedText, String actualText, boolean caseSensitive, String message) throws Exception {
        if (caseSensitive) {
            if (!actualText.equals(expectedText)) {
                throw new Exception(message);
            }
        } else if (!actualText.equalsIgnoreCase(expectedText)) {
            throw new Exception(message + " (ignoring case)");
        }
    }

    private void checkContains(String expectedText, String actualText, boolean caseSensitive, String message) throws Exception {
        if (caseSensitive) {
            if (!actualText.contains(expectedText)) {
                throw new Exception(message);
            }
        } else {
            String expectedText_lowerCase = expectedText.toLowerCase();
            String actualText_lowerCase = actualText.toLowerCase();
            if (!actualText_lowerCase.contains(expectedText_lowerCase)) {
                throw new Exception(message + " (ignoring case)");
            }
        }
    }

    private void checkStartsWith(String expectedText, String actualText, boolean caseSensitive, String message) throws Exception {
        if (caseSensitive) {
            if (!actualText.startsWith(expectedText)) {
                throw new Exception(message);
            }
        } else {
            String expectedText_lowerCase = expectedText.toLowerCase();
            String actualText_lowerCase = actualText.toLowerCase();
            if (!actualText_lowerCase.startsWith(expectedText_lowerCase)) {
                throw new Exception(message + " (ignoring case)");
            }
        }
    }

    private void checkEndsWith(String expectedText, String actualText, boolean caseSensitive, String message) throws Exception {
        if (caseSensitive) {
            if (!actualText.endsWith(expectedText)) {
                throw new Exception(message);
            }
        } else {
            String expectedText_lowerCase = expectedText.toLowerCase();
            String actualText_lowerCase = actualText.toLowerCase();
            if (!actualText_lowerCase.endsWith(expectedText_lowerCase)) {
                throw new Exception(message + " (ignoring case)");
            }
        }
    }

    protected static String getActualText(WebElement elm) {
        if (elm == null) {
            return "";
        }
        if (elm.getTagName().equalsIgnoreCase("input") || elm.getTagName().equalsIgnoreCase("textarea")) {
            String text = elm.getAttribute("value");
            return text == null ? "" : text;
        }
        return elm.getText();
    }
}

