/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.io.File;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.WebDriverCommandExecutor;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.Parameter;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.TestStep;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;

public class ClearCommand
extends WebDriverCommandExecutor {
    private static final String COMMAND = "clear";
    private static final String PAR_ELEMENT = "element";

    public ClearCommand(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface);
    }

    public TestStepResult execute(TestStep aStep, RunTimeData aVariables, File aLogDir) throws TestSuiteException {
        ParameterArrayList parameters = aStep.getParameters();
        this.verifyParameters(parameters);
        TestStepResult result = new TestStepResult(aStep);
        Parameter elementPar = parameters.get(PAR_ELEMENT);
        WebElement element = this.getVariableValueAs(WebElement.class, elementPar, aVariables);
        try {
            element.clear();
            result.setResult(TestResult.VERDICT.PASSED);
        }
        catch (StaleElementReferenceException sere) {
            result.setResult(TestResult.VERDICT.FAILED);
            result.addComment(sere.getLocalizedMessage());
        }
        return result;
    }

    public boolean verifyParameters(ParameterArrayList aParameters) throws TestSuiteException {
        Parameter elementPar = aParameters.get(PAR_ELEMENT);
        if (elementPar == null) {
            throw new TestSuiteException("Parameter element is not set", this.getInterfaceName() + "." + COMMAND);
        }
        this.verifyParameterVariable(elementPar);
        return true;
    }
}

