/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.configuration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.configuration.SeleniumInterfacesXmlHandler;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.RunTimeVariable;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class PersonalSeleniumConfigurationXmlHandler
extends XmlHandler {
    private static final String START_ELEMENT = "SeleniumConfiguration";
    private static final String DEF_BROWSER_ELEMENT = "DefaultBrowser";
    private static final String SAVE_PAGESOURCE = "SavePageSource";
    private static final String SAVE_SCREENSHOT = "SaveScreenshot";
    private static final String SELENIUM_GRID_URL_ELEMENT = "SeleniumGridUrl";
    private GenericTagAndStringXmlHandler myDefaultBrowserXmlHandler;
    private GenericTagAndStringXmlHandler mySavePageSourceXmlHandler;
    private GenericTagAndStringXmlHandler mySaveScreenShotXmlHandler;
    private GenericTagAndStringXmlHandler mySeleniumGridUrlXmlHandler;
    private SeleniumInterfacesXmlHandler myInterfacesXmlHandler;
    private SeleniumConfiguration.BROWSER_TYPE myDefaultBrowser = null;
    private URL mySeleniumGridUrl = null;
    private ArrayList<String> myInterfaceNames;
    private RunTimeData myRtData;

    public PersonalSeleniumConfigurationXmlHandler(XMLReader anXmlReader, RunTimeData anRtData) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.mySeleniumGridUrl = null;
        this.myRtData = anRtData;
        this.myDefaultBrowserXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, DEF_BROWSER_ELEMENT);
        this.addElementHandler((XmlHandler)this.myDefaultBrowserXmlHandler);
        this.mySeleniumGridUrlXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, SELENIUM_GRID_URL_ELEMENT);
        this.addElementHandler((XmlHandler)this.mySeleniumGridUrlXmlHandler);
        this.mySavePageSourceXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, SAVE_PAGESOURCE);
        this.addElementHandler((XmlHandler)this.mySavePageSourceXmlHandler);
        this.mySaveScreenShotXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, SAVE_SCREENSHOT);
        this.addElementHandler((XmlHandler)this.mySaveScreenShotXmlHandler);
        this.myInterfacesXmlHandler = new SeleniumInterfacesXmlHandler(anXmlReader);
        this.addElementHandler(this.myInterfacesXmlHandler);
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) throws TestSuiteException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("handleReturnFromChildElement( " + aQualifiedName + " )"), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase(DEF_BROWSER_ELEMENT)) {
            SeleniumConfiguration.BROWSER_TYPE browserType = SeleniumConfiguration.BROWSER_TYPE.enumOf(this.myDefaultBrowserXmlHandler.getValue());
            RunTimeVariable browserTypeVar = new RunTimeVariable("browsertype", (Object)browserType);
            this.myRtData.add(browserTypeVar);
            this.myDefaultBrowser = browserType;
            this.myDefaultBrowserXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(SELENIUM_GRID_URL_ELEMENT)) {
            String seleniumGridUrl = this.mySeleniumGridUrlXmlHandler.getValue();
            seleniumGridUrl = this.myRtData.substituteVars(seleniumGridUrl);
            try {
                this.mySeleniumGridUrl = new URL(seleniumGridUrl);
            }
            catch (MalformedURLException e) {
                throw new TestSuiteException("\"SeleniumGridUrl\" is malformed: " + e.getMessage(), (Exception)e);
            }
            this.mySeleniumGridUrlXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(SAVE_PAGESOURCE)) {
            String savePageSource = this.mySavePageSourceXmlHandler.getValue();
            if (!(savePageSource.equalsIgnoreCase("NEVER") || savePageSource.equalsIgnoreCase("ONFAIL") || savePageSource.equalsIgnoreCase("ALWAYS"))) {
                throw new TestSuiteException("\"" + savePageSource + "\" is not allowed for " + SAVE_PAGESOURCE + ". Only NEVER, ONFAIL, or ALWAYS");
            }
            RunTimeVariable savePageSourceVar = new RunTimeVariable("savePageSource", (Object)savePageSource.toUpperCase());
            this.myRtData.add(savePageSourceVar);
            this.mySavePageSourceXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(SAVE_SCREENSHOT)) {
            String saveScreenshots = this.mySaveScreenShotXmlHandler.getValue();
            if (!(saveScreenshots.equalsIgnoreCase("NEVER") || saveScreenshots.equalsIgnoreCase("ONFAIL") || saveScreenshots.equalsIgnoreCase("ALWAYS"))) {
                throw new TestSuiteException("\"" + saveScreenshots + "\" is not allowed for " + SAVE_SCREENSHOT + ". Only NEVER, ONFAIL, or ALWAYS");
            }
            RunTimeVariable saveScreenshotsVar = new RunTimeVariable("saveScreenShot", (Object)saveScreenshots.toUpperCase());
            this.myRtData.add(saveScreenshotsVar);
            this.mySaveScreenShotXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(this.myInterfacesXmlHandler.getStartElement())) {
            this.myInterfaceNames = this.myInterfacesXmlHandler.getInterfaceNames();
            this.myInterfacesXmlHandler.reset();
        } else {
            throw new Error("Child XML Handler returned, but not recognized. The handler was probably defined in the Constructor but not handled in handleReturnFromChildElement()");
        }
    }

    public SeleniumConfiguration getConfiguration() {
        return new SeleniumConfiguration(this.myInterfaceNames, this.myDefaultBrowser, null, this.mySeleniumGridUrl);
    }
}

