/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import com.google.common.base.Function;
import java.util.ArrayList;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import net.sf.testium.selenium.SmartWebElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.Warning;

public class WaitFor
extends GenericSeleniumCommandExecutor {
    private static final SpecifiedParameter PARSPEC_ELEMENT = new SpecifiedParameter("element", SmartWebElement.class, false, false, true, false);
    private static final SpecifiedParameter PARSPEC_PRESENT = new SpecifiedParameter("present", Boolean.class, true, true, false, false).setDefaultValue((Object)true);
    private static final SpecifiedParameter PARSPEC_TIMEOUT = new SpecifiedParameter("timeout", Long.class, true, true, true, false).setDefaultValue((Object)5L);
    private static final SpecifiedParameter PARSPEC_SLEEPTIME = new SpecifiedParameter("sleeptime", Long.class, true, true, true, false).setDefaultValue((Object)500L);
    private static final String COMMAND = "waitFor";

    public WaitFor(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_ELEMENT);
        this.addParamSpec(PARSPEC_PRESENT);
        this.addParamSpec(PARSPEC_TIMEOUT);
        this.addParamSpec(PARSPEC_SLEEPTIME);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepResult result) throws Exception {
        Warning.println((String)"Command \"WaitFor\" is deprecated and will be removed soon. Please replace by WaitForVisible, which is the same.");
        WebElement element = this.obtainElement(aVariables, parameters, PARSPEC_ELEMENT);
        if (!(element instanceof SmartWebElement)) {
            throw new Exception("Mandatory element is not a SmartWebElement");
        }
        SmartWebElement smartElement = (SmartWebElement)element;
        Boolean presentFlag = (Boolean)this.obtainOptionalValue(aVariables, parameters, PARSPEC_PRESENT);
        Long timeout = (Long)this.obtainOptionalValue(aVariables, parameters, PARSPEC_TIMEOUT);
        Long sleeptime = (Long)this.obtainOptionalValue(aVariables, parameters, PARSPEC_SLEEPTIME);
        if (presentFlag.booleanValue()) {
            new WebDriverWait(this.getDriver(), timeout.longValue(), sleeptime.longValue()).until((Function)ExpectedConditions.visibilityOf((WebElement)smartElement));
        } else {
            new WebDriverWait(this.getDriver(), timeout.longValue(), sleeptime.longValue()).until((Function)new isNotVisible(smartElement));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class isNotVisible
    implements ExpectedCondition<Boolean> {
        WebElement element;

        public isNotVisible(WebElement element) {
            this.element = element;
        }

        public Boolean apply(WebDriver input) {
            try {
                if (!this.element.isDisplayed()) {
                    return true;
                }
            }
            catch (WebDriverException ignored) {
                return true;
            }
            return false;
        }
    }
}

