/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.WebDriverCommandExecutor;
import org.openqa.selenium.WebDriver;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.TestStep;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;

public class SavePageSourceCommand
extends WebDriverCommandExecutor {
    private static final String COMMAND = "savePageSource";

    public SavePageSourceCommand(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface);
    }

    public TestStepResult execute(TestStep aStep, RunTimeData aVariables, File aLogDir) throws TestSuiteException {
        ParameterArrayList parameters = aStep.getParameters();
        this.verifyParameters(parameters);
        TestStepResult result = new TestStepResult(aStep);
        WebDriver webDriver = this.getDriver();
        String pageSource = webDriver.getPageSource();
        this.savePageSource(aLogDir, result, pageSource);
        return result;
    }

    public void savePageSource(File aLogDir, TestStepResult result, String pageSource) {
        int i = 0;
        String sourceLogKey = "source";
        File sourceLog = new File(aLogDir, "page_" + sourceLogKey + ".html");
        while (sourceLog.exists() && ++i < 100) {
            sourceLogKey = "source_" + i;
            sourceLog = new File(aLogDir, "page_" + sourceLogKey + ".html");
        }
        try {
            FileOutputStream sourceLogOS = new FileOutputStream(sourceLog.getAbsolutePath());
            PrintWriter pw = new PrintWriter(sourceLogOS);
            pw.println(pageSource);
            pw.flush();
            result.addTestLog(sourceLogKey, sourceLog.getPath());
            result.setResult(TestResult.VERDICT.PASSED);
        }
        catch (FileNotFoundException e) {
            result.setComment("Source file could not be saved: " + e.getMessage());
            result.setResult(TestResult.VERDICT.FAILED);
        }
    }

    public boolean verifyParameters(ParameterArrayList aParameters) throws TestSuiteException {
        return true;
    }
}

