/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.io.File;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.executor.TestStepCommandExecutor;
import net.sf.testium.executor.webdriver.WebInterface;
import org.openqa.selenium.WebDriver;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.Parameter;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.ParameterImpl;
import org.testtoolinterfaces.testsuite.ParameterVariable;
import org.testtoolinterfaces.testsuite.TestStep;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebDriverCommandExecutor
implements TestStepCommandExecutor {
    private final String myCommand;
    private final WebInterface myInterface;

    public abstract TestStepResult execute(TestStep var1, RunTimeData var2, File var3) throws TestSuiteException;

    public abstract boolean verifyParameters(ParameterArrayList var1) throws TestSuiteException;

    public WebDriverCommandExecutor(String aCommand, WebInterface aWebInterface) {
        this.myCommand = aCommand;
        this.myInterface = aWebInterface;
    }

    protected WebInterface getInterface() {
        return this.myInterface;
    }

    public String getCommand() {
        return this.myCommand;
    }

    public String getInterfaceName() {
        return this.myInterface.getInterfaceName();
    }

    @Deprecated
    protected WebDriver getDriver(SeleniumConfiguration.BROWSER_TYPE aBrowserType) {
        WebDriver webDriver = this.myInterface.getDriver(aBrowserType);
        return webDriver;
    }

    protected WebDriver getDriver() {
        return this.myInterface.getDriver();
    }

    protected void verifyParameterValue(Parameter aPar, Class<? extends Object> aType) throws TestSuiteException {
        if (aPar == null) {
            throw new TestSuiteException("Parameter is not set", this.getInterfaceName() + "." + this.getCommand());
        }
        String parName = aPar.getName();
        if (!ParameterImpl.class.isInstance(aPar)) {
            throw new TestSuiteException("Parameter " + parName + " is not a value", this.getInterfaceName() + "." + this.getCommand());
        }
        ParameterImpl parameter = (ParameterImpl)aPar;
        if (!parameter.getValueType().equals(aType)) {
            throw new TestSuiteException("Parameter " + parName + " must be a " + aType.getSimpleName(), this.getInterfaceName() + "." + this.getCommand());
        }
        if (aType == String.class && parameter.getValueAsString().isEmpty()) {
            throw new TestSuiteException(parName + " cannot be empty", this.getInterfaceName() + "." + this.getCommand());
        }
    }

    protected void verifyParameterVariable(Parameter aPar) throws TestSuiteException {
        if (aPar == null) {
            throw new TestSuiteException("Parameter is not set", this.getInterfaceName() + "." + this.getCommand());
        }
        String parName = aPar.getName();
        if (!ParameterVariable.class.isInstance(aPar)) {
            throw new TestSuiteException("Parameter " + parName + " is not defined as a variable", this.getInterfaceName() + "." + this.getCommand());
        }
        if (((ParameterVariable)aPar).getVariableName().isEmpty()) {
            throw new TestSuiteException("Variable name of " + parName + " cannot be empty", this.getInterfaceName() + "." + this.getCommand());
        }
    }

    protected <Type> Type getVariableValueAs(Class<Type> aType, Parameter aPar, RunTimeData aVariables) throws TestSuiteException {
        Object valueOfType = null;
        ParameterVariable parVariable = (ParameterVariable)aPar;
        String variableName = parVariable.getVariableName();
        if (!aVariables.containsKey(variableName)) {
            throw new TestSuiteException("Variable " + variableName + " is not set", this.getInterfaceName() + "." + this.getCommand());
        }
        valueOfType = aVariables.getValueAs(aType, variableName);
        if (valueOfType == null) {
            throw new TestSuiteException("Variable " + variableName + " is not of type " + aType.getSimpleName(), this.getInterfaceName() + "." + this.getCommand());
        }
        return (Type)valueOfType;
    }
}

