/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.util.ArrayList;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.openqa.selenium.WebDriver;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.utils.RunTimeData;

public class CheckCurrentUrl
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "checkCurrentUrl";
    private static final String PAR_URL = "url";
    public static final SpecifiedParameter PARSPEC_URL = new SpecifiedParameter("url", String.class, false, true, true, false);

    public CheckCurrentUrl(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_URL);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepResult result) throws Exception {
        WebDriver webDriver = this.getDriver();
        String expectedUrl = (String)this.obtainValue(aVariables, parameters, PARSPEC_URL);
        String currentUrl = webDriver.getCurrentUrl();
        if (!currentUrl.equalsIgnoreCase(expectedUrl)) {
            throw new Exception("url has value '" + currentUrl + "'. Expected '" + expectedUrl + "' (ignoring case)");
        }
    }
}

