/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.selenium;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.testium.selenium.SmartWebElementList;
import net.sf.testium.selenium.WebDriverInterface;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleElementList
extends ArrayList<WebElement>
implements SmartWebElementList {
    private static final long serialVersionUID = 1L;
    private final By myBy;
    private final WebDriverInterface myInterface;
    private WebElement myBaseElement;

    public SimpleElementList(By by, WebDriverInterface iface) {
        this(by, iface, new ArrayList(), null);
    }

    public SimpleElementList(By by, WebDriverInterface iface, Collection<? extends WebElement> elements) {
        this(by, iface, elements, null);
    }

    public SimpleElementList(By by, WebDriverInterface iface, Collection<? extends WebElement> elements, WebElement baseElement) {
        if (elements != null) {
            super.addAll(elements);
        }
        this.myBy = by;
        this.myInterface = iface;
        this.myBaseElement = baseElement;
    }

    @Override
    public By getBy() {
        return this.myBy;
    }

    public WebDriverInterface getInterface() {
        return this.myInterface;
    }

    public List<WebElement> getElements() {
        if (super.size() == 0) {
            this.refresh();
        }
        return this;
    }

    public void refresh() {
        super.clear();
        if (this.myBaseElement != null) {
            super.addAll(this.myBaseElement.findElements(this.myBy));
        } else {
            WebDriver driver = this.getInterface().getDriver();
            if (driver == null) {
                throw new Error("Element requested, but driver is not yet created: '" + this.myBy + "'. Make sure this interface (" + this.getInterface().toString() + ") opens a browser first.");
            }
            super.addAll(driver.findElements(this.myBy));
        }
    }
}

