/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.util.ArrayList;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import net.sf.testium.selenium.SimplePageElement;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.RunTimeVariable;

public class FindElementCommand
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "findElement";
    public static final SpecifiedParameter PARSPEC_BY = new SpecifiedParameter("by", By.class, false, true, true, false);
    public static final SpecifiedParameter PARSPEC_ELEMENT = new SpecifiedParameter("element", String.class, false, true, false, false);
    public static final SpecifiedParameter PARSPEC_BASEELEMENT = new SpecifiedParameter("baseElement", WebElement.class, true, false, true, false);

    public FindElementCommand(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_BY);
        this.addParamSpec(PARSPEC_ELEMENT);
        this.addParamSpec(PARSPEC_BASEELEMENT);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepResult result) throws Exception {
        By by = (By)this.obtainValue(aVariables, parameters, PARSPEC_BY);
        String elementName = (String)this.obtainValue(aVariables, parameters, PARSPEC_ELEMENT);
        try {
            WebElement baseElement = this.obtainElement(aVariables, parameters, PARSPEC_BASEELEMENT);
            WebElement element = baseElement != null ? baseElement.findElement(by) : this.getDriver().findElement(by);
            SimplePageElement smartElement = new SimplePageElement(by, this.getInterface(), element);
            RunTimeVariable rtVariable = new RunTimeVariable(elementName, (Object)smartElement);
            aVariables.add(rtVariable);
        }
        catch (NoSuchElementException nsee) {
            throw new TestSuiteException("Element could not be found", result.getCommand(), result.getSequenceNr(), (Exception)((Object)nsee));
        }
    }
}

