/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.io.File;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.WebDriverCommandExecutor;
import org.openqa.selenium.WebDriver;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.Parameter;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.ParameterImpl;
import org.testtoolinterfaces.testsuite.ParameterVariable;
import org.testtoolinterfaces.testsuite.TestStep;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;

public class CheckTitleCommand
extends WebDriverCommandExecutor {
    private static final String COMMAND = "checkTitle";
    private static final String PAR_TITLE = "title";

    public CheckTitleCommand(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface);
    }

    public TestStepResult execute(TestStep aStep, RunTimeData aVariables, File aLogDir) throws TestSuiteException {
        ParameterArrayList parameters = aStep.getParameters();
        this.verifyParameters(parameters);
        SeleniumConfiguration.BROWSER_TYPE browserType = (SeleniumConfiguration.BROWSER_TYPE)((Object)aVariables.getValueAs(SeleniumConfiguration.BROWSER_TYPE.class, "browsertype"));
        TestStepResult result = new TestStepResult(aStep);
        WebDriver webDriver = this.getDriver(browserType);
        String expectedTitle = "";
        Parameter titlePar = parameters.get(PAR_TITLE);
        if (titlePar.getClass().equals(ParameterVariable.class)) {
            expectedTitle = this.getVariableValueAs(String.class, titlePar, aVariables);
        } else if (ParameterImpl.class.isInstance(titlePar)) {
            expectedTitle = ((ParameterImpl)titlePar).getValueAsString();
        } else {
            throw new TestSuiteException("parameter must be value or variable: " + titlePar.getName());
        }
        String title = webDriver.getTitle();
        if (title.equals(expectedTitle)) {
            result.setResult(TestResult.PASSED);
        } else {
            result.setResult(TestResult.FAILED);
            result.setComment("title has value '" + title + "'. Expected '" + expectedTitle + "'");
        }
        return result;
    }

    public boolean verifyParameters(ParameterArrayList aParameters) throws TestSuiteException {
        Parameter valuePar = aParameters.get(PAR_TITLE);
        if (valuePar == null) {
            throw new TestSuiteException("Parameter title is not set", this.getInterfaceName() + "." + COMMAND);
        }
        if (valuePar.getClass().equals(ParameterVariable.class)) {
            this.verifyParameterVariable(valuePar);
        } else {
            this.verifyParameterValue(valuePar, String.class);
        }
        return true;
    }
}

