/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.configuration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.Warning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumConfiguration {
    public static final String PROPERTY_WEBDRIVER_IE_IGNORING_SECURITY_DOMAINS = "webdriver.ie.ignoringsecuritydomains";
    public static final BROWSER_TYPE FIREFOX = BROWSER_TYPE.FIREFOX;
    public static final BROWSER_TYPE CHROME = BROWSER_TYPE.CHROME;
    public static final BROWSER_TYPE HTMLUNIT = BROWSER_TYPE.HTMLUNIT;
    public static final BROWSER_TYPE IE = BROWSER_TYPE.IE;
    public static final String BROWSERTYPE = "browsertype";
    public static final String VARNAME_SAVEPAGESOURCE = "savePageSource";
    public static final String VARNAME_SAVESCREENSHOT = "saveScreenShot";
    private ArrayList<String> myInterfaceNames;
    private BROWSER_TYPE myBrowser;
    private File mySeleniumLibsDir;
    private URL mySeleniumGridUrl;

    public SeleniumConfiguration(ArrayList<String> anInterfaceNames, BROWSER_TYPE aBrowser, File aSeleniumLibsDir, URL aSeleniumGridUrl) {
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.myInterfaceNames = anInterfaceNames;
        this.myBrowser = aBrowser;
        this.mySeleniumLibsDir = aSeleniumLibsDir;
        this.mySeleniumGridUrl = aSeleniumGridUrl;
    }

    public ArrayList<String> getInterfaceNames() {
        return this.myInterfaceNames;
    }

    public File getSeleniumLibsDir() {
        return this.mySeleniumLibsDir;
    }

    public BROWSER_TYPE getBrowserType() {
        return this.myBrowser;
    }

    public URL getSeleniumGridUrl() {
        return this.mySeleniumGridUrl;
    }

    public static void setChromeDriver(File chromeDriver) {
        System.setProperty("webdriver.chrome.driver", chromeDriver.getAbsolutePath());
    }

    public static void setIeDriver(File ieDriver) {
        System.setProperty("webdriver.ie.driver", ieDriver.getAbsolutePath());
    }

    public static void setIeIgnoreSecurityDomains(Boolean aFlag) {
        System.setProperty(PROPERTY_WEBDRIVER_IE_IGNORING_SECURITY_DOMAINS, aFlag.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BROWSER_TYPE {
        FIREFOX,
        CHROME,
        HTMLUNIT,
        IE;


        public String toString() {
            return super.toString().toLowerCase();
        }

        public static BROWSER_TYPE enumOf(String aType) {
            BROWSER_TYPE value = HTMLUNIT;
            if (aType == null) {
                Warning.println((String)("Browser type is null.\nContinuing with " + value.toString()));
            } else if (aType.isEmpty()) {
                Warning.println((String)("Browser type is empty.\nContinuing with " + value.toString()));
            } else {
                try {
                    value = Enum.valueOf(BROWSER_TYPE.class, aType.toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    String allTypes = "";
                    for (BROWSER_TYPE supportedType : BROWSER_TYPE.values()) {
                        allTypes = allTypes.isEmpty() ? supportedType.toString() : allTypes + ", " + (Object)((Object)supportedType);
                    }
                    Warning.println((String)("Browser type " + aType + " is not supported.\nSupported types are " + allTypes + ".\nContinuing with " + value.toString()));
                }
            }
            return value;
        }
    }
}

