/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.plugins;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.testium.Testium;
import net.sf.testium.configuration.ConfigurationException;
import net.sf.testium.configuration.PersonalSeleniumConfigurationXmlHandler;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.configuration.SeleniumConfigurationXmlHandler;
import net.sf.testium.executor.DefaultInterface;
import net.sf.testium.executor.SupportedInterfaceList;
import net.sf.testium.executor.TestStepCommandExecutor;
import net.sf.testium.executor.TestStepMetaExecutor;
import net.sf.testium.executor.webdriver.commands.CheckListSize_modified;
import net.sf.testium.executor.webdriver.commands.GetListItem_modified;
import net.sf.testium.executor.webdriver.commands.GetListSize_modified;
import net.sf.testium.plugins.Plugin;
import net.sf.testium.plugins.PluginClassLoader;
import net.sf.testium.plugins.PluginCollection;
import net.sf.testium.systemundertest.SutInterface;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.TTIException;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SeleniumPlugin
implements Plugin {
    public void loadPlugIn(PluginCollection aPluginCollection, RunTimeData anRtData) throws ConfigurationException {
        SupportedInterfaceList interfaceList = aPluginCollection.getInterfaces();
        TestStepMetaExecutor testStepMetaExecutor = aPluginCollection.getTestStepExecutor();
        File pluginsDir = anRtData.getValueAsFile(Testium.PLUGINSDIR);
        File seleniumLibsDir = new File(pluginsDir, "SeleniumLibs");
        try {
            PluginClassLoader.addDirToClassLoader((File)seleniumLibsDir);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException((Throwable)e);
        }
        DefaultInterface defInterface = (DefaultInterface)interfaceList.getInterface("Default");
        defInterface.add((TestStepCommandExecutor)new CheckListSize_modified((SutInterface)defInterface));
        defInterface.add((TestStepCommandExecutor)new GetListItem_modified((SutInterface)defInterface));
        defInterface.add((TestStepCommandExecutor)new GetListSize_modified(defInterface));
        this.readConfigFile(anRtData, interfaceList, testStepMetaExecutor);
    }

    public final SeleniumConfiguration readConfigFile(RunTimeData anRtData, SupportedInterfaceList anInterfaceList, TestStepMetaExecutor aTestStepMetaExecutor) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        File configDir = (File)anRtData.getValue(Testium.CONFIGDIR);
        File configFile = new File(configDir, "selenium.xml");
        SeleniumConfiguration config = this.readConfigFile(anRtData, configFile, anInterfaceList, aTestStepMetaExecutor);
        File userConfigDir = (File)anRtData.getValue(Testium.USERCONFIGDIR);
        File userConfigFile = new File(userConfigDir, "selenium.xml");
        if (userConfigFile.exists()) {
            this.readPersonalConfigFile(anRtData, userConfigFile, anInterfaceList, aTestStepMetaExecutor);
        }
        return config;
    }

    public final SeleniumConfiguration readConfigFile(RunTimeData anRtData, File aConfigFile, SupportedInterfaceList anInterfaceList, TestStepMetaExecutor aTestStepMetaExecutor) throws ConfigurationException {
        SeleniumConfigurationXmlHandler myHandler;
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("readConfigFile( " + aConfigFile.getName() + " )"), (boolean)true);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(false);
        try {
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            myHandler = new SeleniumConfigurationXmlHandler(xmlReader, anInterfaceList, aTestStepMetaExecutor, anRtData);
            xmlReader.setContentHandler((ContentHandler)((Object)myHandler));
            xmlReader.parse(aConfigFile.getAbsolutePath());
        }
        catch (ParserConfigurationException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        catch (SAXException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        catch (IOException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        SeleniumConfiguration configuration = myHandler.getConfiguration();
        return configuration;
    }

    public final SeleniumConfiguration readPersonalConfigFile(RunTimeData anRtData, File aConfigFile, SupportedInterfaceList anInterfaceList, TestStepMetaExecutor aTestStepMetaExecutor) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("readConfigFile( " + aConfigFile.getName() + " )"), (boolean)true);
        PersonalSeleniumConfigurationXmlHandler myHandler = null;
        try {
            XMLReader reader = XmlHandler.getNewXmlReader();
            myHandler = new PersonalSeleniumConfigurationXmlHandler(reader, anInterfaceList, aTestStepMetaExecutor, anRtData);
            myHandler.parse(reader, aConfigFile);
        }
        catch (TTIException e) {
            e.printStackTrace();
        }
        SeleniumConfiguration configuration = myHandler.getConfiguration();
        return configuration;
    }
}

