/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.configuration;

import java.io.File;
import net.sf.testium.configuration.ConfigurationException;
import net.sf.testium.configuration.CustomStepDefinitionsXmlHandler;
import net.sf.testium.configuration.CustomStepXmlHandler;
import net.sf.testium.executor.CustomInterface;
import net.sf.testium.executor.SupportedInterfaceList;
import net.sf.testium.executor.TestStepMetaExecutor;
import net.sf.testium.executor.webdriver.WebInterface;
import org.testtoolinterfaces.testsuite.TestInterface;
import org.testtoolinterfaces.testsuite.TestInterfaceList;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.TTIException;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class SeleniumInterfaceXmlHandler
extends XmlHandler {
    public static final String START_ELEMENT = "SeleniumInterface";
    private static final String ATTR_NAME = "name";
    private static final String BASE_URL_ELEMENT = "BaseUrl";
    private static final String CUSTOMSTEP_DEFINITIONS_LINK_ELEMENT = "CustomStepDefinitionsLink";
    private GenericTagAndStringXmlHandler myBaseUrlXmlHandler;
    private CustomStepXmlHandler myCustomStepXmlHandler;
    private GenericTagAndStringXmlHandler myCustomStepDefinitionsLinkXmlHandler;
    private TestInterface myInterface;
    private String myInterfaceName;
    private final RunTimeData myRtData;
    private SupportedInterfaceList myInterfaceList;
    private String myBaseUrl;
    private final TestStepMetaExecutor myTestStepMetaExecutor;

    public SeleniumInterfaceXmlHandler(XMLReader anXmlReader, SupportedInterfaceList anInterfaceList, TestStepMetaExecutor aTestStepMetaExecutor, RunTimeData anRtData) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.myRtData = anRtData;
        this.myInterfaceList = anInterfaceList;
        this.myTestStepMetaExecutor = aTestStepMetaExecutor;
        this.myBaseUrlXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, BASE_URL_ELEMENT);
        this.addElementHandler((XmlHandler)this.myBaseUrlXmlHandler);
        this.myCustomStepXmlHandler = new CustomStepXmlHandler(anXmlReader, (TestInterfaceList)anInterfaceList, aTestStepMetaExecutor);
        this.addElementHandler((XmlHandler)this.myCustomStepXmlHandler);
        this.myCustomStepDefinitionsLinkXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, CUSTOMSTEP_DEFINITIONS_LINK_ELEMENT);
        this.addElementHandler((XmlHandler)this.myCustomStepDefinitionsLinkXmlHandler);
        this.reset();
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("handleEndElement( " + aQualifiedName + " )"), (boolean)true);
        if (this.myInterface == null) {
            this.createInterface();
        }
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) throws TTIException {
        Trace.print((Trace.LEVEL)Trace.SUITE, (String)("processElementAttributes( " + aQualifiedName), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase(START_ELEMENT)) {
            for (int i = 0; i < att.getLength(); ++i) {
                Trace.append((Trace.LEVEL)Trace.SUITE, (String)(", " + att.getQName(i) + "=" + att.getValue(i)));
                if (!att.getQName(i).equalsIgnoreCase(ATTR_NAME)) {
                    throw new Error("The attribute '" + att.getQName(i) + "' is not supported for configuration of the Selenium Plugin, element " + START_ELEMENT);
                }
                this.myInterfaceName = att.getValue(i);
            }
        }
        Trace.append((Trace.LEVEL)Trace.SUITE, (String)" )\n");
    }

    public void handleGoToChildElement(String aQualifiedName) {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("handleGoToChildElement( " + aQualifiedName + " )"), (boolean)true);
        if (this.myInterface == null) {
            this.createInterface();
        }
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) throws TTIException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("handleReturnFromChildElement( " + aQualifiedName + " )"), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase(BASE_URL_ELEMENT)) {
            this.myBaseUrl = this.myBaseUrlXmlHandler.getValue();
            this.myBaseUrlXmlHandler.reset();
            if (this.myInterface instanceof WebInterface) {
                ((WebInterface)this.myInterface).setBaseUrl(this.myBaseUrl);
            }
        } else if (aQualifiedName.equalsIgnoreCase("CustomStep")) {
            if (this.myInterface == null) {
                throw new TTIException("The interface is not defined. Unable to add a step to an unknown interface");
            }
            if (!CustomInterface.class.isInstance(this.myInterface)) {
                throw new TTIException("The " + this.myInterface.getInterfaceName() + " interface is not customizable. " + "Unable to add a step to it.");
            }
            try {
                this.myCustomStepXmlHandler.addTestStepExecutor((CustomInterface)this.myInterface);
            }
            catch (TestSuiteException e) {
                throw new TTIException("Unable to add a step: " + e.getMessage(), (Exception)((Object)e));
            }
            this.myCustomStepXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(CUSTOMSTEP_DEFINITIONS_LINK_ELEMENT)) {
            String fileName = this.myCustomStepDefinitionsLinkXmlHandler.getValue();
            this.myCustomStepDefinitionsLinkXmlHandler.reset();
            fileName = this.myRtData.substituteVars(fileName);
            if (!(this.myInterface instanceof CustomInterface)) {
                throw new TTIException("Interface is not customizable: " + this.myInterface.getInterfaceName());
            }
            try {
                CustomStepDefinitionsXmlHandler.loadElementDefinitions((File)new File(fileName), (RunTimeData)this.myRtData, (CustomInterface)((CustomInterface)this.myInterface), (TestInterfaceList)this.myInterfaceList, (TestStepMetaExecutor)this.myTestStepMetaExecutor);
            }
            catch (ConfigurationException ce) {
                throw new TTIException("Failed to load element Definitions from file: " + fileName, (Exception)((Object)ce));
            }
        } else {
            throw new Error("Child XML Handler returned, but not recognized. The handler was probably defined in the Constructor but not handled in handleReturnFromChildElement()");
        }
    }

    private void createInterface() {
        if (this.myInterfaceName.isEmpty()) {
            throw new Error("Attribute name is not defined for Selenium Interface");
        }
        this.myInterface = this.myInterfaceList.getInterface(this.myInterfaceName);
        if (this.myInterface == null) {
            this.myInterface = new WebInterface(this.myInterfaceName, this.myRtData, this.myBaseUrl);
            this.myInterfaceList.add(this.myInterface);
        }
    }

    public void reset() {
        this.myInterface = null;
        this.myInterfaceName = "";
        this.myBaseUrl = System.getProperty("baseUrl");
    }
}

