/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.configuration;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.testium.configuration.ConfigurationException;
import net.sf.testium.configuration.DefineElementListXmlHandler;
import net.sf.testium.configuration.DefineElementXmlHandler;
import net.sf.testium.selenium.WebDriverInterface;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.TTIException;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LoadDefinitionsXmlHandler
extends XmlHandler {
    private static final String START_ELEMENT = "ElementDefinitions";
    private static final String ELEMENT_DEFINITIONS_LINK_ELEMENT = "ElementDefinitionsLink";
    private DefineElementXmlHandler myDefineElementXmlHandler;
    private DefineElementListXmlHandler myDefineElementListXmlHandler;
    private GenericTagAndStringXmlHandler myElementDefinitionsLinkXmlHandler;
    private final RunTimeData myRtData;
    private final WebDriverInterface myInterface;

    public LoadDefinitionsXmlHandler(XMLReader anXmlReader, RunTimeData anRtData, WebDriverInterface anInterface) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.myRtData = anRtData;
        this.myInterface = anInterface;
        this.myDefineElementXmlHandler = new DefineElementXmlHandler(anXmlReader, anRtData, anInterface);
        this.addElementHandler(this.myDefineElementXmlHandler);
        this.myDefineElementListXmlHandler = new DefineElementListXmlHandler(anXmlReader, anRtData, anInterface);
        this.addElementHandler(this.myDefineElementListXmlHandler);
        this.myElementDefinitionsLinkXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_DEFINITIONS_LINK_ELEMENT);
        this.addElementHandler((XmlHandler)this.myElementDefinitionsLinkXmlHandler);
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) throws TTIException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("handleReturnFromChildElement( " + aQualifiedName + " )"), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase(ELEMENT_DEFINITIONS_LINK_ELEMENT)) {
            String fileName = this.myElementDefinitionsLinkXmlHandler.getValue();
            this.myElementDefinitionsLinkXmlHandler.reset();
            fileName = this.myRtData.substituteVars(fileName);
            try {
                LoadDefinitionsXmlHandler.loadElementDefinitions(new File(fileName), this.myRtData, this.myInterface);
            }
            catch (ConfigurationException ce) {
                throw new TTIException("Failed to load element Definitions from file: " + fileName, (Exception)((Object)ce));
            }
        }
        if (aQualifiedName.equalsIgnoreCase(this.myDefineElementXmlHandler.getStartElement())) {
            try {
                this.myDefineElementXmlHandler.defineElement();
            }
            catch (ConfigurationException e) {
                this.myDefineElementXmlHandler.reset();
                throw new TTIException("Failed to load element Definition", (Exception)((Object)e));
            }
            this.myDefineElementXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(this.myDefineElementListXmlHandler.getStartElement())) {
            try {
                this.myDefineElementListXmlHandler.defineElementList();
            }
            catch (ConfigurationException e) {
                this.myDefineElementListXmlHandler.reset();
                throw new TTIException("Failed to load elementList Definition", (Exception)((Object)e));
            }
            this.myDefineElementListXmlHandler.reset();
        }
    }

    public static void loadElementDefinitions(File aFile, RunTimeData anRtData, WebDriverInterface anInterface) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("loadElementDefinitions( " + aFile.getName() + " )"), (boolean)true);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(false);
        try {
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            LoadDefinitionsXmlHandler handler = new LoadDefinitionsXmlHandler(xmlReader, anRtData, anInterface);
            xmlReader.setContentHandler((ContentHandler)((Object)handler));
            xmlReader.parse(aFile.getAbsolutePath());
        }
        catch (ParserConfigurationException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        catch (SAXException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        catch (IOException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
    }
}

