/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.io.File;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.WebDriverCommandExecutor;
import org.openqa.selenium.WebDriver;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.Parameter;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.ParameterVariable;
import org.testtoolinterfaces.testsuite.TestStep;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.RunTimeVariable;

public class GetTitleCommand
extends WebDriverCommandExecutor {
    private static final String COMMAND = "getTitle";
    private static final String PAR_TITLE = "title";

    public GetTitleCommand(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface);
    }

    public TestStepResult execute(TestStep aStep, RunTimeData aVariables, File aLogDir) throws TestSuiteException {
        ParameterArrayList parameters = aStep.getParameters();
        this.verifyParameters(parameters);
        SeleniumConfiguration.BROWSER_TYPE browserType = (SeleniumConfiguration.BROWSER_TYPE)((Object)aVariables.getValueAs(SeleniumConfiguration.BROWSER_TYPE.class, "browsertype"));
        TestStepResult result = new TestStepResult(aStep);
        WebDriver webDriver = this.getDriver(browserType);
        ParameterVariable titlePar = (ParameterVariable)parameters.get(PAR_TITLE);
        String variableName = titlePar.getVariableName();
        String title = webDriver.getTitle();
        RunTimeVariable rtVariable = new RunTimeVariable(variableName, (Object)title);
        aVariables.add(rtVariable);
        result.setResult(TestResult.VERDICT.PASSED);
        return result;
    }

    public boolean verifyParameters(ParameterArrayList aParameters) throws TestSuiteException {
        Parameter titlePar = aParameters.get(PAR_TITLE);
        if (titlePar == null) {
            throw new TestSuiteException("Parameter title is not set", this.getInterfaceName() + "." + COMMAND);
        }
        this.verifyParameterVariable(titlePar);
        return true;
    }
}

