/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.executor.CustomInterface;
import net.sf.testium.executor.TestStepCommandExecutor;
import net.sf.testium.executor.webdriver.TestiumChromeDriver;
import net.sf.testium.executor.webdriver.TestiumFirefoxDriver;
import net.sf.testium.executor.webdriver.TestiumIeDriver;
import net.sf.testium.executor.webdriver.TestiumUnitDriver;
import net.sf.testium.executor.webdriver.commands.Back;
import net.sf.testium.executor.webdriver.commands.CentralizeItem;
import net.sf.testium.executor.webdriver.commands.CheckAttribute;
import net.sf.testium.executor.webdriver.commands.CheckCurrentUrl;
import net.sf.testium.executor.webdriver.commands.CheckEditable;
import net.sf.testium.executor.webdriver.commands.CheckSelected;
import net.sf.testium.executor.webdriver.commands.CheckText;
import net.sf.testium.executor.webdriver.commands.CheckTitleCommand;
import net.sf.testium.executor.webdriver.commands.ClearCommand;
import net.sf.testium.executor.webdriver.commands.Click;
import net.sf.testium.executor.webdriver.commands.CloseCommand;
import net.sf.testium.executor.webdriver.commands.CtrlClick;
import net.sf.testium.executor.webdriver.commands.DefineElement;
import net.sf.testium.executor.webdriver.commands.DefineElementList;
import net.sf.testium.executor.webdriver.commands.FindElementCommand;
import net.sf.testium.executor.webdriver.commands.FindElementsCommand;
import net.sf.testium.executor.webdriver.commands.ForwardCommand;
import net.sf.testium.executor.webdriver.commands.Get;
import net.sf.testium.executor.webdriver.commands.GetAttribute;
import net.sf.testium.executor.webdriver.commands.GetCurrentUrlCommand;
import net.sf.testium.executor.webdriver.commands.GetTitleCommand;
import net.sf.testium.executor.webdriver.commands.LoadElementDefinitions;
import net.sf.testium.executor.webdriver.commands.QuitCommand;
import net.sf.testium.executor.webdriver.commands.RefreshCommand;
import net.sf.testium.executor.webdriver.commands.SavePageSourceCommand;
import net.sf.testium.executor.webdriver.commands.SelectValue;
import net.sf.testium.executor.webdriver.commands.SendKeys;
import net.sf.testium.executor.webdriver.commands.Submit;
import net.sf.testium.executor.webdriver.commands.WaitFor;
import net.sf.testium.executor.webdriver.commands.WaitForPresent;
import net.sf.testium.executor.webdriver.commands.WaitForVisible;
import net.sf.testium.selenium.FieldPublisher;
import net.sf.testium.selenium.WebDriverInterface;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.ParameterImpl;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.RunTimeVariable;
import org.testtoolinterfaces.utils.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebInterface
extends CustomInterface
implements FieldPublisher,
WebDriverInterface {
    private WebDriver myDriver;
    private final RunTimeData myRtData;
    private String myBaseUrl;

    public WebInterface(String aName, RunTimeData aRtData, String aBaseUrl) {
        super(aName);
        this.myRtData = aRtData;
        this.setBaseUrl(aBaseUrl);
        this.add((TestStepCommandExecutor)new Back(this));
        this.add((TestStepCommandExecutor)new CentralizeItem(this));
        this.add((TestStepCommandExecutor)new CheckAttribute(this));
        this.add((TestStepCommandExecutor)new CheckCurrentUrl(this));
        this.add((TestStepCommandExecutor)new CheckEditable(this));
        this.add((TestStepCommandExecutor)new CheckSelected(this));
        this.add((TestStepCommandExecutor)new CheckText(this));
        this.add(new CheckTitleCommand(this));
        this.add(new ClearCommand(this));
        this.add((TestStepCommandExecutor)new Click(this));
        this.add(new CloseCommand(this));
        this.add((TestStepCommandExecutor)new CtrlClick(this));
        this.add((TestStepCommandExecutor)new DefineElement(this));
        this.add((TestStepCommandExecutor)new DefineElementList(this));
        this.add((TestStepCommandExecutor)new FindElementCommand(this));
        this.add((TestStepCommandExecutor)new FindElementsCommand(this));
        this.add(new ForwardCommand(this));
        this.add((TestStepCommandExecutor)new Get(this));
        this.add((TestStepCommandExecutor)new GetAttribute(this));
        this.add(new GetCurrentUrlCommand(this));
        this.add(new GetTitleCommand(this));
        this.add((TestStepCommandExecutor)new LoadElementDefinitions(this));
        this.add(new QuitCommand(this));
        this.add(new RefreshCommand(this));
        this.add(new SavePageSourceCommand(this));
        this.add((TestStepCommandExecutor)new SelectValue(this));
        this.add((TestStepCommandExecutor)new SendKeys(this));
        this.add((TestStepCommandExecutor)new Submit(this));
        this.add((TestStepCommandExecutor)new WaitFor(this));
        this.add((TestStepCommandExecutor)new WaitForPresent(this));
        this.add((TestStepCommandExecutor)new WaitForVisible(this));
    }

    public void setBaseUrl(String aBaseUrl) {
        this.myBaseUrl = aBaseUrl;
    }

    @Override
    public String getBaseUrl() {
        return this.myBaseUrl;
    }

    public WebDriver getDriver(SeleniumConfiguration.BROWSER_TYPE aType) {
        if (this.myDriver == null) {
            this.createDriver(aType);
        }
        return this.myDriver;
    }

    @Override
    public WebDriver getDriver() {
        return this.myDriver;
    }

    protected void setDriver(WebDriver aDriver) {
        this.myDriver = aDriver;
    }

    public void closeWindow(TestStepResult aTestStepResult) {
        if (this.myDriver == null) {
            return;
        }
        this.setTestStepResult(aTestStepResult);
        Set windowHandles = this.myDriver.getWindowHandles();
        int openWindows = windowHandles.size();
        this.myDriver.close();
        if (openWindows == 1) {
            this.setDriver(null);
        }
        this.setTestStepResult(null);
    }

    public void quitDriver(TestStepResult aTestStepResult) {
        if (this.myDriver == null) {
            return;
        }
        this.setTestStepResult(aTestStepResult);
        this.myDriver.quit();
        this.setTestStepResult(null);
        this.setDriver(null);
    }

    public void setTestStepResult(TestStepResult aTestStepResult) {
        if (this.myDriver == null) {
            return;
        }
    }

    protected void createDriver(SeleniumConfiguration.BROWSER_TYPE aType) {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        try {
            if (aType.equals((Object)SeleniumConfiguration.BROWSER_TYPE.FIREFOX)) {
                this.setDriver((WebDriver)new TestiumFirefoxDriver(this));
            } else if (aType.equals((Object)SeleniumConfiguration.BROWSER_TYPE.CHROME)) {
                DesiredCapabilities capabilities = DesiredCapabilities.chrome();
                ArrayList<String> switches = new ArrayList<String>();
                switches.add("disable-translate");
                capabilities.setCapability("chrome.switches", switches);
                try {
                    this.setDriver((WebDriver)new TestiumChromeDriver(this, capabilities));
                }
                catch (Throwable t) {
                    System.out.println(t.getLocalizedMessage());
                }
            } else if (aType.equals((Object)SeleniumConfiguration.BROWSER_TYPE.HTMLUNIT)) {
                this.setDriver((WebDriver)new TestiumUnitDriver(this));
            } else if (aType.equals((Object)SeleniumConfiguration.BROWSER_TYPE.IE)) {
                DesiredCapabilities capabilities = DesiredCapabilities.internetExplorer();
                String ignoreSecurityDomains = System.getProperty("webdriver.ie.ignoringsecuritydomains");
                capabilities.setCapability("ignoreProtectedModeSettings", (Object)new Boolean(ignoreSecurityDomains));
                this.setDriver((WebDriver)new TestiumIeDriver(this, capabilities));
            }
        }
        catch (WebDriverException e) {
            throw new Error("Browser of type " + (Object)((Object)aType) + " is not found.\n" + e.getMessage());
        }
    }

    public ParameterImpl createParameter(String aName, String aType, String aValue) throws TestSuiteException {
        try {
            return super.createParameter(aName, aType, aValue);
        }
        catch (TestSuiteException ignored) {
            By by = WebInterface.getBy(aType, aValue);
            if (by != null) {
                return new ParameterImpl(aName, (Object)by);
            }
            throw new TestSuiteException("Parameter type " + aType + " is not supported for interface " + this.getInterfaceName(), aName);
        }
    }

    @Override
    public void addElement(String varName, WebElement element) {
        if (element == null) {
            return;
        }
        RunTimeVariable rtVar = new RunTimeVariable(varName, (Object)element);
        this.myRtData.add(rtVar);
    }

    @Override
    public void addElement(String varName, List<WebElement> elements) {
        if (elements == null) {
            return;
        }
        RunTimeVariable rtVar = new RunTimeVariable(varName, elements);
        this.myRtData.add(rtVar);
    }

    @Override
    public WebElement getElement(String varName) {
        WebElement element = (WebElement)this.myRtData.getValueAs(WebElement.class, varName);
        return element;
    }

    public String toString() {
        return this.getInterfaceName();
    }

    public void destroy() {
        if (this.myDriver == null) {
            return;
        }
        this.myDriver.quit();
        this.setDriver(null);
    }

    public static By getBy(String aType, String aValue) {
        if (aType.equalsIgnoreCase("id")) {
            return By.id((String)aValue);
        }
        if (aType.equalsIgnoreCase("name")) {
            return By.name((String)aValue);
        }
        if (aType.equalsIgnoreCase("linktext")) {
            return By.linkText((String)aValue);
        }
        if (aType.equalsIgnoreCase("partiallinktext")) {
            return By.partialLinkText((String)aValue);
        }
        if (aType.equalsIgnoreCase("tagname")) {
            return By.tagName((String)aValue);
        }
        if (aType.equalsIgnoreCase("xpath")) {
            return By.xpath((String)aValue);
        }
        if (aType.equalsIgnoreCase("classname")) {
            return By.className((String)aValue);
        }
        if (aType.equalsIgnoreCase("cssselector")) {
            return By.cssSelector((String)aValue);
        }
        return null;
    }
}

