/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.plugins;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.testium.Testium;
import net.sf.testium.configuration.ConfigurationException;
import net.sf.testium.configuration.PerlConfiguration;
import net.sf.testium.configuration.PerlConfigurationXmlHandler;
import net.sf.testium.executor.TestCaseAbstractExecutor;
import net.sf.testium.executor.TestCaseExecutor;
import net.sf.testium.executor.TestCasePerlExecutor;
import net.sf.testium.executor.TestStepPerlExecutor;
import net.sf.testium.executor.TestStepScriptExecutor;
import net.sf.testium.plugins.Plugin;
import net.sf.testium.plugins.PluginCollection;
import org.testtoolinterfaces.testresultinterface.TestCaseResultWriter;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.Trace;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class PerlTestPlugin
implements Plugin {
    public void loadPlugIn(PluginCollection aPluginCollection, RunTimeData anRtData) throws ConfigurationException {
        PerlConfiguration config = this.readConfigFiles(anRtData);
        TestStepPerlExecutor perlTsExecutor = new TestStepPerlExecutor(config);
        aPluginCollection.addStepScriptExecutor((TestStepScriptExecutor)perlTsExecutor);
        TestCaseResultWriter tcResultWriter = aPluginCollection.getTestCaseResultWriter();
        TestCasePerlExecutor perlTcExecutor = new TestCasePerlExecutor(config, tcResultWriter);
        aPluginCollection.addTestCaseExecutor((TestCaseExecutor)perlTcExecutor);
    }

    public PerlConfiguration readConfigFiles(RunTimeData anRtData) throws ConfigurationException {
        TestCaseAbstractExecutor.LOGTYPE resultType;
        String settingsOption;
        String logDirOption;
        File settingsFile;
        Trace.println((Trace.LEVEL)Trace.UTIL);
        File configDir = (File)anRtData.getValue(Testium.CONFIGDIR);
        File configFile = new File(configDir, "perl.xml");
        PerlConfiguration globalConfig = this.readConfigFile(configFile, anRtData);
        File userConfigDir = (File)anRtData.getValue(Testium.USERCONFIGDIR);
        File userConfigFile = new File(userConfigDir, "perl.xml");
        PerlConfiguration userConfig = new PerlConfiguration(null, null, false, null, TestCaseAbstractExecutor.LOGTYPE.NONE, true);
        if (userConfigFile.exists()) {
            userConfig = this.readConfigFile(userConfigFile, anRtData);
        }
        if ((settingsFile = userConfig.getSettingsFile()) == null) {
            settingsFile = globalConfig.getSettingsFile();
        }
        if ((logDirOption = userConfig.getLogFileOption()) == null && (logDirOption = globalConfig.getLogFileOption()) == null) {
            logDirOption = "-l";
        }
        boolean passSettings = userConfig.getPassSettings();
        if (userConfig.isPassSettingsDefault()) {
            passSettings = globalConfig.getPassSettings();
            if (globalConfig.isPassSettingsDefault()) {
                passSettings = false;
            }
        }
        if ((settingsOption = userConfig.getSettingsOption()) == null && (settingsOption = globalConfig.getSettingsOption()) == null) {
            settingsOption = "-c";
        }
        if ((resultType = userConfig.getResultType()) == null && (resultType = globalConfig.getResultType()) == null) {
            resultType = TestCaseAbstractExecutor.LOGTYPE.LOGONLY;
        }
        PerlConfiguration config = new PerlConfiguration(settingsFile, logDirOption, passSettings, settingsOption, resultType);
        return config;
    }

    public PerlConfiguration readConfigFile(File aConfigFile, RunTimeData anRtData) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("readConfigFile( " + aConfigFile.getName() + " )"), (boolean)true);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(false);
        PerlConfigurationXmlHandler handler = null;
        try {
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            handler = new PerlConfigurationXmlHandler(xmlReader, anRtData);
            xmlReader.setContentHandler((ContentHandler)((Object)handler));
            xmlReader.parse(aConfigFile.getAbsolutePath());
        }
        catch (ParserConfigurationException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        catch (SAXException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        catch (IOException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        PerlConfiguration myConfiguration = handler.getConfiguration();
        return myConfiguration;
    }
}

