/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.testium.configuration.PerlConfiguration;
import net.sf.testium.executor.PerlScript;
import net.sf.testium.executor.TestStepScriptAbstractExecutor;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testsuite.TestStepScript;

public class TestStepPerlExecutor
extends TestStepScriptAbstractExecutor {
    public static final String TYPE = "perl";
    private PerlConfiguration myConfiguration;

    public TestStepPerlExecutor(PerlConfiguration aConfig) {
        this.myConfiguration = aConfig;
    }

    public File executeScript(TestStepScript aStep, File aPerlScript, TestStepResult aResult, File aLogDir) {
        File runLog = new File(aLogDir, aPerlScript.getName() + "_run.log");
        String stepId = aStep.getId();
        File resultFile = new File(aLogDir, stepId + ".xml");
        try {
            aResult.setResult(PerlScript.execute(aPerlScript, aStep.getParameters(), resultFile, runLog, this.myConfiguration));
        }
        catch (FileNotFoundException e) {
            aResult.addComment("Execution Failed: " + e.getMessage());
            aResult.setResult(TestResult.VERDICT.ERROR);
        }
        return runLog;
    }

    public String getType() {
        return TYPE;
    }
}

