/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import net.sf.testium.configuration.PerlConfiguration;
import net.sf.testium.executor.PerlScript;
import net.sf.testium.executor.TestCaseExecutor;
import org.testtoolinterfaces.testresult.TestCaseResult;
import org.testtoolinterfaces.testresult.TestCaseResultLink;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresultinterface.TestCaseResultReader;
import org.testtoolinterfaces.testresultinterface.TestCaseResultWriter;
import org.testtoolinterfaces.testsuite.LooseTestInterfaceList;
import org.testtoolinterfaces.testsuite.TestCase;
import org.testtoolinterfaces.testsuite.TestCaseImpl;
import org.testtoolinterfaces.testsuite.TestCaseLink;
import org.testtoolinterfaces.testsuite.TestInterfaceList;
import org.testtoolinterfaces.testsuite.TestStepSequence;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCasePerlExecutor
implements TestCaseExecutor {
    public static final String TYPE = "perl";
    private PerlConfiguration myConfiguration;
    private TestCaseResultWriter myTestCaseResultWriter;
    private TestCaseResultReader myTestCaseResultReader;

    public TestCasePerlExecutor(PerlConfiguration aConfig, TestCaseResultWriter aTestCaseResultWriter) {
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.myConfiguration = aConfig;
        this.myTestCaseResultWriter = aTestCaseResultWriter;
        LooseTestInterfaceList interfaceList = new LooseTestInterfaceList();
        this.myTestCaseResultReader = new TestCaseResultReader((TestInterfaceList)interfaceList);
    }

    public TestCaseResultLink execute(TestCaseLink aTestCaseLink, File aLogDir, RunTimeData anRTData) {
        TestCaseResult result;
        String tcId = aTestCaseLink.getId();
        Trace.println((Trace.LEVEL)Trace.EXEC, (String)("execute( " + tcId + ", " + aLogDir.getPath() + ", " + anRTData.size() + " Variables )"), (boolean)true);
        if (!aLogDir.isDirectory()) {
            FileNotFoundException exc = new FileNotFoundException("Directory does not exist: " + aLogDir.getPath());
            throw new IOError(exc);
        }
        File executable = aTestCaseLink.getLink();
        File caseLogDir = new File(aLogDir, tcId);
        caseLogDir.mkdir();
        File resultFile = new File(caseLogDir, tcId + ".xml");
        File origResultFile = new File(caseLogDir, tcId + "_orig.xml");
        File logFile = new File(caseLogDir, tcId + "_run.log");
        try {
            TestResult.VERDICT retCodeVerdict = PerlScript.execute(executable, resultFile, logFile, this.myConfiguration);
            this.copy(resultFile, origResultFile);
            result = this.readResultFile(resultFile);
            result.setResult(retCodeVerdict);
            this.myTestCaseResultWriter.write(result, resultFile);
        }
        catch (FileNotFoundException e) {
            String description = this.getDescription(executable);
            ArrayList<String> requirements = this.getRequirements(executable);
            TestCaseImpl pseudoTestCase = new TestCaseImpl(tcId, description, 0, requirements, new TestStepSequence(), new TestStepSequence(), new TestStepSequence(), new Hashtable(), new Hashtable());
            result = new TestCaseResult((TestCase)pseudoTestCase);
            resultFile = new File(caseLogDir, tcId + "_error.xml");
            this.myTestCaseResultWriter.write(result, resultFile);
            result.addComment("Execution Failed: " + e.getLocalizedMessage());
            StackTraceElement[] elms = e.getStackTrace();
            for (int key = 0; key < elms.length; ++key) {
                result.addComment(elms[key].toString());
            }
            result.setResult(TestResult.VERDICT.ERROR);
        }
        result.addTestLog("log", logFile.getPath());
        return new TestCaseResultLink(aTestCaseLink, result.getResult(), resultFile);
    }

    public String getType() {
        return TYPE;
    }

    private String getDescription(File aPerlScript) {
        return "";
    }

    private ArrayList<String> getRequirements(File aPerlScript) {
        return new ArrayList<String>();
    }

    private TestCaseResult readResultFile(File aResultFile) throws FileNotFoundException {
        try {
            return this.myTestCaseResultReader.readTcResultFile(aResultFile);
        }
        catch (IOError anIoError) {
            String msg = anIoError.getMessage();
            StackTraceElement[] elms = anIoError.getStackTrace();
            for (int key = 0; key < elms.length; ++key) {
                msg = msg + "\n" + elms[key].toString();
            }
            throw new FileNotFoundException(msg);
        }
    }

    private void copy(File src, File dst) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            Trace.print((Trace.LEVEL)Trace.EXEC_PLUS, (Throwable)e);
        }
    }
}

