/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.sf.testium.configuration.PerlConfiguration;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.ParameterImpl;
import org.testtoolinterfaces.utils.StreamGobbler;
import org.testtoolinterfaces.utils.Trace;

public class PerlScript {
    public static TestResult.VERDICT execute(File aScript, File aResultFile, File aRunLog, PerlConfiguration aConfiguration) throws FileNotFoundException {
        return PerlScript.execute(aScript, new ParameterArrayList(), aResultFile, aRunLog, aConfiguration);
    }

    public static TestResult.VERDICT execute(File aScript, ParameterArrayList aParameters, File aResultFile, File aRunLog, PerlConfiguration aConfiguration) throws FileNotFoundException {
        if (aScript == null) {
            throw new NullPointerException("Script cannot be null");
        }
        if (aScript.isDirectory()) {
            throw new FileNotFoundException("Script cannot be a directory: " + aScript.getPath());
        }
        if (aResultFile == null) {
            throw new NullPointerException("Result File cannot be null");
        }
        if (aResultFile.isDirectory()) {
            throw new FileNotFoundException("Result File cannot be a Directory: " + aResultFile.getPath());
        }
        if (aRunLog == null) {
            throw new NullPointerException("Run log cannot be null");
        }
        if (aRunLog.isDirectory()) {
            throw new FileNotFoundException("Run log cannot be a Directory: " + aRunLog.getAbsolutePath());
        }
        Trace.println((Trace.LEVEL)Trace.EXEC_PLUS, (String)("execute( " + aScript.getPath() + ", " + aParameters.size() + " Parameters, " + aResultFile.getPath() + ", " + aRunLog.getPath() + ", " + "PerlConfiguration )"), (boolean)true);
        FileOutputStream runLog = new FileOutputStream(aRunLog.getAbsolutePath());
        if (!aScript.canExecute()) {
            PrintWriter pw = new PrintWriter(runLog);
            pw.println("Cannot execute file:");
            pw.println(aScript.getAbsolutePath());
            pw.flush();
            throw new FileNotFoundException("Cannot execute file: " + aScript.getName());
        }
        String baseLogName = aRunLog.getName().substring(0, aRunLog.getName().lastIndexOf(46));
        String commandString = aScript.getAbsolutePath();
        ParameterArrayList params = aParameters.sort();
        for (int i = 0; i < params.size(); ++i) {
            if (!ParameterImpl.class.isInstance(params.get(i))) continue;
            ParameterImpl param = (ParameterImpl)params.get(i);
            commandString = commandString + " " + param.getName() + " " + param.getValue().toString();
        }
        Trace.println((Trace.LEVEL)Trace.EXEC_PLUS, (String)("Executing " + commandString));
        Trace.println((Trace.LEVEL)Trace.EXEC_PLUS, (String)("Writing result to " + aResultFile.getAbsolutePath()));
        Trace.println((Trace.LEVEL)Trace.EXEC_PLUS, (String)("Writing log to " + aRunLog.getAbsolutePath()));
        commandString = commandString + " " + aConfiguration.getLogFileOption();
        commandString = commandString + " " + aResultFile.getAbsolutePath();
        if (aConfiguration.getPassSettings()) {
            commandString = commandString + " " + aConfiguration.getSettingsOption();
            commandString = commandString + " " + aConfiguration.getSettingsFile().getAbsolutePath();
        }
        File commandLogFile = new File(aRunLog.getParent(), baseLogName + "_command.log");
        try {
            BufferedWriter commandLog = new BufferedWriter(new FileWriter(commandLogFile));
            commandLog.write(commandString + "\n");
            commandLog.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(commandString);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), (OutputStream)runLog);
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), (OutputStream)runLog);
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                throw new Error(e);
            }
            runLog.flush();
            runLog.close();
            Trace.println((Trace.LEVEL)Trace.EXEC_PLUS, (String)("Exit value is " + exitVal));
            if (exitVal > 0) {
                return TestResult.FAILED;
            }
            return TestResult.PASSED;
        }
        catch (Throwable t) {
            Long logSize = new Long(0L);
            if (aRunLog.exists() && aRunLog.isFile()) {
                logSize = aRunLog.length();
            }
            if (logSize.intValue() == 0) {
                PrintWriter pw = new PrintWriter(runLog);
                pw.println("Error while executing perl script:");
                pw.println(t.getMessage());
                pw.flush();
            }
            throw new FileNotFoundException("Error while executing perl script: " + t.getMessage());
        }
    }
}

