/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.configuration;

import java.io.File;
import java.util.ArrayList;
import net.sf.testium.configuration.ConfigurationException;
import net.sf.testium.configuration.PerlConfiguration;
import net.sf.testium.executor.TestCaseAbstractExecutor;
import org.testtoolinterfaces.utils.GenericTagAndBooleanXmlHandler;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class PerlConfigurationXmlHandler
extends XmlHandler {
    private static final String START_ELEMENT = "PerlConfiguration";
    private static final String CFG_LOGFILE_OPTION = "logfileOption";
    private static final String CFG_PASS_SETTINGS = "passSettings";
    private static final String CFG_SETTINGS_OPTION = "settingsOption";
    private static final String CFG_SETTINGS_FILE = "settingsFile";
    private static final String CFG_RESULT_TYPE = "resultType";
    private File mySettingsFile = null;
    private String myLogFileOption = null;
    private boolean myPassSettings = false;
    private boolean isPassSettingsDefault = true;
    private String mySettingsOption = null;
    private TestCaseAbstractExecutor.LOGTYPE myResultType = TestCaseAbstractExecutor.LOGTYPE.NONE;
    private RunTimeData myRunTimeData;

    public PerlConfigurationXmlHandler(XMLReader anXmlReader, RunTimeData anRtData) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.myRunTimeData = anRtData;
        ArrayList<Object> xmlHandlers = new ArrayList<Object>();
        xmlHandlers.add(new GenericTagAndStringXmlHandler(anXmlReader, CFG_LOGFILE_OPTION));
        xmlHandlers.add(new GenericTagAndBooleanXmlHandler(anXmlReader, CFG_PASS_SETTINGS));
        xmlHandlers.add(new GenericTagAndStringXmlHandler(anXmlReader, CFG_SETTINGS_OPTION));
        xmlHandlers.add(new GenericTagAndStringXmlHandler(anXmlReader, CFG_SETTINGS_FILE));
        xmlHandlers.add(new GenericTagAndStringXmlHandler(anXmlReader, CFG_RESULT_TYPE));
        for (XmlHandler xmlHandler : xmlHandlers) {
            this.addElementHandler(xmlHandler.getStartElement(), xmlHandler);
        }
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("handleReturnFromChildElement( " + aQualifiedName + " )"), (boolean)true);
        if (!GenericTagAndStringXmlHandler.class.isInstance(aChildXmlHandler)) {
            throw new Error("ChildXmlHandler (" + aChildXmlHandler.getClass().toString() + ") must be of type GenericTagAndStringXmlHandler");
        }
        GenericTagAndStringXmlHandler childXmlHandler = (GenericTagAndStringXmlHandler)aChildXmlHandler;
        if (aQualifiedName.equalsIgnoreCase(CFG_SETTINGS_FILE)) {
            String settingsFileName = this.myRunTimeData.substituteVars(childXmlHandler.getValue());
            this.mySettingsFile = new File(settingsFileName);
            aChildXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(CFG_LOGFILE_OPTION)) {
            this.myLogFileOption = childXmlHandler.getValue();
            aChildXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(CFG_PASS_SETTINGS)) {
            this.myPassSettings = ((GenericTagAndBooleanXmlHandler)childXmlHandler).getBoolean();
            this.isPassSettingsDefault = false;
            aChildXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(CFG_SETTINGS_OPTION)) {
            this.mySettingsOption = childXmlHandler.getValue();
            aChildXmlHandler.reset();
        }
        aChildXmlHandler.reset();
    }

    public PerlConfiguration getConfiguration() throws ConfigurationException {
        return new PerlConfiguration(this.mySettingsFile, this.myLogFileOption, this.myPassSettings, this.mySettingsOption, this.myResultType, this.isPassSettingsDefault);
    }
}

