package net.sf.testium.plugins;

import java.io.File;
import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import net.sf.testium.Testium;
import net.sf.testium.configuration.ConfigurationException;
import net.sf.testium.configuration.PerlConfiguration;
import net.sf.testium.configuration.PerlConfigurationXmlHandler;
import net.sf.testium.executor.TestCasePerlExecutor;
import net.sf.testium.executor.TestStepPerlExecutor;
import net.sf.testium.executor.TestCaseAbstractExecutor.LOGTYPE;
//import net.sf.testium.executor.TestCaseAbstractExecutor.LOGTYPE;
import net.sf.testium.plugins.Plugin;
import net.sf.testium.plugins.PluginCollection;
import org.testtoolinterfaces.testresultinterface.TestCaseResultWriter;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.Trace;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;


/**
 * @author Arjan Kranenburg
 *
 */
public final class PerlTestPlugin implements Plugin
{
	public PerlTestPlugin()
	{
		// nop
	}
	
	public void loadPlugIn(PluginCollection aPluginCollection,
			RunTimeData anRtData) throws ConfigurationException
	{
		PerlConfiguration config = readConfigFiles( anRtData );
		
		// Executors
		TestStepPerlExecutor perlTsExecutor = new TestStepPerlExecutor( config );
		aPluginCollection.addStepScriptExecutor(perlTsExecutor);

		TestCaseResultWriter tcResultWriter = aPluginCollection.getTestCaseResultWriter();
		TestCasePerlExecutor perlTcExecutor = new TestCasePerlExecutor( config, tcResultWriter );
		aPluginCollection.addTestCaseExecutor(perlTcExecutor);		
	}

	public PerlConfiguration readConfigFiles( RunTimeData anRtData ) throws ConfigurationException
	{
		Trace.println(Trace.UTIL);

		File configDir = (File) anRtData.getValue(Testium.CONFIGDIR);
		File configFile = new File( configDir, "perl.xml" );
		PerlConfiguration globalConfig = readConfigFile( configFile, anRtData );
		
		File userConfigDir = (File) anRtData.getValue(Testium.USERCONFIGDIR);
		File userConfigFile = new File( userConfigDir, "perl.xml" );
		PerlConfiguration userConfig = new PerlConfiguration( null, null, false, null, LOGTYPE.NONE, true);
		if ( userConfigFile.exists() )
		{
			userConfig = readConfigFile( userConfigFile, anRtData );
		}

		File settingsFile = userConfig.getSettingsFile();
		if (settingsFile == null)
		{
			settingsFile = globalConfig.getSettingsFile();
		}

		String logDirOption = userConfig.getLogFileOption();
		if (logDirOption == null)
		{
			logDirOption = globalConfig.getLogFileOption();
			if (logDirOption == null)
			{
				logDirOption = "-l";
			}
		}
		
		boolean passSettings = userConfig.getPassSettings();
		if (userConfig.isPassSettingsDefault())
		{
			passSettings = globalConfig.getPassSettings();
			if (globalConfig.isPassSettingsDefault())
			{
				passSettings = false;
			}
		}

		String settingsOption = userConfig.getSettingsOption();
		if (settingsOption == null)
		{
			settingsOption = globalConfig.getSettingsOption();
			if (settingsOption == null)
			{
				settingsOption = "-c";
			}
		}
		
		LOGTYPE resultType = userConfig.getResultType();
		if (resultType == null)
		{
			resultType = globalConfig.getResultType();
			if (resultType == null)
			{
				resultType = LOGTYPE.LOGONLY;
			}
		}
		
		PerlConfiguration config = new PerlConfiguration( settingsFile, logDirOption, passSettings, settingsOption, resultType );

		return config;
	}
	
	public PerlConfiguration readConfigFile( File aConfigFile, RunTimeData anRtData ) throws ConfigurationException
	{
		Trace.println(Trace.UTIL, "readConfigFile( " + aConfigFile.getName() + " )", true );
        // create a parser
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(false);
        SAXParser saxParser;
        PerlConfigurationXmlHandler handler = null;
		try
		{
			saxParser = spf.newSAXParser();
			XMLReader xmlReader = saxParser.getXMLReader();

	        // create a handler
			handler = new PerlConfigurationXmlHandler(xmlReader, anRtData);

	        // assign the handler to the parser
	        xmlReader.setContentHandler(handler);

	        // parse the document
	        xmlReader.parse( aConfigFile.getAbsolutePath() );
		}
		catch (ParserConfigurationException e)
		{
			Trace.print(Trace.UTIL, e);
			throw new ConfigurationException( e );
		}
		catch (SAXException e)
		{
			Trace.print(Trace.UTIL, e);
			throw new ConfigurationException( e );
		}
		catch (IOException e)
		{
			Trace.print(Trace.UTIL, e);
			throw new ConfigurationException( e );
		}
		
		PerlConfiguration myConfiguration = handler.getConfiguration();
		
		return myConfiguration;
	}
}
