package net.sf.testium.configuration;

import java.io.File;
import java.util.ArrayList;

import net.sf.testium.executor.TestCaseAbstractExecutor.LOGTYPE;

import net.sf.testium.configuration.ConfigurationException;
import org.testtoolinterfaces.utils.GenericTagAndBooleanXmlHandler;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;


public class PerlConfigurationXmlHandler extends XmlHandler
{
	private static final String START_ELEMENT = "PerlConfiguration";

	private static final String	CFG_LOGFILE_OPTION	= "logfileOption";
	private static final String	CFG_PASS_SETTINGS	= "passSettings";
	private static final String	CFG_SETTINGS_OPTION	= "settingsOption";
	private static final String	CFG_SETTINGS_FILE	= "settingsFile";
	private static final String	CFG_RESULT_TYPE	    = "resultType";

	private File mySettingsFile = null;
	private String myLogFileOption = null;
	private boolean myPassSettings = false;
	private boolean isPassSettingsDefault = true;
	private String mySettingsOption = null;
	private LOGTYPE myResultType = LOGTYPE.NONE;

	private RunTimeData myRunTimeData;

	public PerlConfigurationXmlHandler(XMLReader anXmlReader, RunTimeData anRtData)
	{
	    super(anXmlReader, START_ELEMENT);
	    Trace.println(Trace.CONSTRUCTOR);

		myRunTimeData = anRtData;

		ArrayList<XmlHandler> xmlHandlers = new ArrayList<XmlHandler>();
	    xmlHandlers.add(new GenericTagAndStringXmlHandler(anXmlReader, CFG_LOGFILE_OPTION));
	    xmlHandlers.add(new GenericTagAndBooleanXmlHandler(anXmlReader, CFG_PASS_SETTINGS));
	    xmlHandlers.add(new GenericTagAndStringXmlHandler(anXmlReader, CFG_SETTINGS_OPTION));
	    xmlHandlers.add(new GenericTagAndStringXmlHandler(anXmlReader, CFG_SETTINGS_FILE));
	    xmlHandlers.add(new GenericTagAndStringXmlHandler(anXmlReader, CFG_RESULT_TYPE));

	    for (XmlHandler handler : xmlHandlers)
	    {
			this.addElementHandler(handler.getStartElement(), handler);
	    }
	}

	@Override
	public void handleStartElement(String aQualifiedName)
	{
		// nop
	}

	@Override
	public void handleCharacters(String aValue)
	{
		// nop
	}

	@Override
	public void handleEndElement(String aQualifiedName)
	{
		// nop
	}

	@Override
	public void processElementAttributes(String aQualifiedName, Attributes att)
	{
		// nop
	}

	@Override
	public void handleGoToChildElement(String aQualifiedName)
	{
		// nop
	}

	@Override
	public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler)
	{
	    Trace.println(Trace.UTIL, "handleReturnFromChildElement( " + 
	    	      aQualifiedName + " )", true);

		if ( ! GenericTagAndStringXmlHandler.class.isInstance(aChildXmlHandler) )
		{
			throw new Error( "ChildXmlHandler (" + aChildXmlHandler.getClass().toString() + ") must be of type GenericTagAndStringXmlHandler" );
		}
		GenericTagAndStringXmlHandler childXmlHandler = (GenericTagAndStringXmlHandler) aChildXmlHandler;

		if (aQualifiedName.equalsIgnoreCase(CFG_SETTINGS_FILE))
    	{
			String settingsFileName = myRunTimeData.substituteVars( childXmlHandler.getValue() );
			mySettingsFile = new File( settingsFileName );
			aChildXmlHandler.reset();
    	}
		else if (aQualifiedName.equalsIgnoreCase(CFG_LOGFILE_OPTION))
    	{
			myLogFileOption = childXmlHandler.getValue();
			aChildXmlHandler.reset();
    	}
		else if (aQualifiedName.equalsIgnoreCase(CFG_PASS_SETTINGS))
    	{
			myPassSettings = ((GenericTagAndBooleanXmlHandler) childXmlHandler).getBoolean();
			isPassSettingsDefault = false;
			aChildXmlHandler.reset();
    	}
		else if (aQualifiedName.equalsIgnoreCase(CFG_SETTINGS_OPTION))
    	{
			mySettingsOption = childXmlHandler.getValue();
			aChildXmlHandler.reset();
    	}
//		else if (aQualifiedName.equalsIgnoreCase(CFG_RESULT_TYPE))
//    	{
//			myResultType = LOGTYPE.valueOf( aChildXmlHandler.getValue() );
//			aChildXmlHandler.reset();
//    	}

   		aChildXmlHandler.reset();
	}
	
	public PerlConfiguration getConfiguration() throws ConfigurationException
	{
		return new PerlConfiguration( mySettingsFile,
									  myLogFileOption,
									  myPassSettings,
									  mySettingsOption,
									  myResultType,
									  isPassSettingsDefault );
	}
}
