package net.sf.testium.configuration;
/**
 * 
 */

import java.io.File;

import net.sf.testium.executor.TestCaseAbstractExecutor.LOGTYPE;
import org.testtoolinterfaces.utils.Trace;

/**
 * @author Arjan Kranenburg
 *
 */
public class PerlConfiguration
{
	private File mySettingsFile;
	private String myLogFileOption;
	private boolean myPassSettings;
	private String mySettingsOption;
	private LOGTYPE myResultType;
	private boolean myIsPassSettingsDefault;   // Dirty, but it serves, since a boolean cannot be null

	/**
	 * @param mySettingsFile
	 * @param myLogFileOption
	 * @param mySettingsOption
	 * @param myResultType
	 */
	public PerlConfiguration( File aSettingsFile,
							  String aLogFileOption,
							  boolean aPassSettings,
							  String aSettingsOption,
							  LOGTYPE aResultType )
	{
	    this( aSettingsFile, aLogFileOption, aPassSettings, aSettingsOption, aResultType, true);
	}

	public PerlConfiguration( File aSettingsFile,
							  String aLogFileOption,
							  boolean aPassSettings,
							  String aSettingsOption,
							  LOGTYPE aResultType,
							  boolean anIsPassSettingsDefault)
	{
	    Trace.println(Trace.CONSTRUCTOR);

	    mySettingsFile = aSettingsFile;
		myLogFileOption = aLogFileOption;
		myPassSettings = aPassSettings;
		mySettingsOption = aSettingsOption;
		myResultType = aResultType;
		myIsPassSettingsDefault = anIsPassSettingsDefault;
	}

	/**
	 * @return the myLogDirOption
	 */
	public String getLogFileOption()
	{
		return myLogFileOption;
	}

	/**
	 * @return the myPassSettings
	 */
	public boolean getPassSettings()
	{
		return myPassSettings;
	}

	/**
	 * @return the mySettingsOption
	 */
	public String getSettingsOption()
	{
		return mySettingsOption;
	}

	/**
	 * @return the mySettingsFile
	 */
	public File getSettingsFile()
	{
		return mySettingsFile;
	}

	/**
	 * @return the myResultType
	 */
	public LOGTYPE getResultType()
	{
		return myResultType;
	}

	/**
	 * @return the myIsPassSettingsDefault
	 */
	public boolean isPassSettingsDefault()
	{
		return myIsPassSettingsDefault;
	}
}
