<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (c) Erinors 2006. All rights reserved. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" doctype-system="http://maven.apache.org/dtd/xdoc_1_0.dtd"
		doctype-public="-//APACHE//DTD Documentation V1.2//EN" />

	<xsl:template match="tapdoc">

		<document>
			<properties>
				<title>TapDoc - Overview</title>
			</properties>
			<body>
				<xsl:apply-templates select="library" />
			</body>
		</document>
	</xsl:template>

	<xsl:template match="library">

		<!-- Display library name -->
		<section name="{@name}">

			<p>
				<xsl:value-of select="description" />
			</p>

			<p>
				<xsl:apply-templates select="component" />
			</p>

		</section>

	</xsl:template>

	<xsl:template match="component">
		<a href="{@link}" title="{description}">
			<xsl:if test="@deprecated = 'true'">
				<span style="text-decoration:line-through;" title="deprecated">
					<xsl:value-of select="@name" />
				</span>
			</xsl:if>
			<xsl:if test="@deprecated = 'false'">
				<xsl:value-of select="@name" />
			</xsl:if>
		</a>
		<br/>
	</xsl:template>

</xsl:stylesheet>
