<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (c) Erinors 2006. All rights reserved. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" doctype-system="http://maven.apache.org/dtd/xdoc_1_0.dtd"
		doctype-public="-//APACHE//DTD Documentation V1.2//EN" />

	<xsl:param name="libraryName" />

	<xsl:template match="library[@name = $libraryName]">

		<document>
			<properties>
				<title>
					TapDoc - Library
					<xsl:value-of select="@name" />
				</title>
			</properties>
			<body>
				<section name="{@name}">
					<p>
						<xsl:value-of select="description" />
					</p>

					<p>
						<xsl:apply-templates select="component" />
					</p>

				</section>
			</body>
		</document>

	</xsl:template>

	<xsl:template match="library[@name != $libraryName]" />

	<xsl:template match="component">
		<a href="../{@link}" title="{description}">
			<xsl:if test="@deprecated = 'true'">
				<span style="text-decoration:line-through;" title="deprecated">
					<xsl:value-of select="@name" />
				</span>
			</xsl:if>
			<xsl:if test="@deprecated = 'false'">
				<xsl:value-of select="@name" />
			</xsl:if>
		</a>
		<br/>
	</xsl:template>

</xsl:stylesheet>
