<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (c) Erinors 2006. All rights reserved. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:output method="html"/>

	<xsl:param name="libraryName" />
	<xsl:param name="componentName" />

	<xsl:template name="InsertHeader">
		<table border="0" width="100%" cellpadding="5" cellspacing="0">
			<tr>
				<td align="left"><a href="../index.html">Library</a></td>
				<td align="right" nowrap="nowrap">
					<xsl:if test="0 != count(preceding-sibling::component)">
						<a href="../../{preceding-sibling::component[position()=1]/@link}">Previous (<xsl:value-of select="preceding-sibling::component[position()=1]/@name" />)</a>
					</xsl:if>
					&#160;
					<xsl:if test="0 != count(following-sibling::component)">
						<a href="../../{following-sibling::component[position()=1]/@link}">Next (<xsl:value-of select="following-sibling::component[position()=1]/@name" />)</a>
					</xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template match="library[@name=$libraryName]/component[@name=$componentName]">
		<html>
			<head>
				<title>TapDoc - Component <xsl:value-of select="$libraryName"/>:<xsl:value-of
						select="$componentName"/></title>
				<META NAME="Generator" CONTENT="TapDoc 1.0 - http://www.erinors.com/" />
				<link href="../../resource/ComponentReference.css" rel="stylesheet"
					type="text/css"/>
			</head>
			<body>
				<xsl:call-template name="InsertHeader"/>
				<hr/>
				
				<table width="100%" border="0" cellpadding="0" cellspacing="0">
					<tr>
						
						<!-- Name and class of the component -->
						<td align="left" valign="top">
							<xsl:if	test="@deprecated = 'true'">
								<span class="DeprecatedComponentName" title="deprecated"><xsl:value-of select="@name"/></span> (deprecated)
							</xsl:if>
							<xsl:if test="@deprecated = 'false'">
								<span class="ComponentName"><xsl:value-of select="@name"/></span>
							</xsl:if>
							<br/>
							
							<xsl:call-template name="linkToClass">
								<xsl:with-param name="name" select="class/@name"/>
								<xsl:with-param name="link" select="class/@url"/>
							</xsl:call-template>
						</td>
						
						<td width="100%">&#160;</td>
						
						<!-- Visual sample of the component if any. -->
						<xsl:choose>
							<xsl:when test="count(visual) = 1 or count(nonvisual) = 1 or count(visual-or-nonvisual) = 1">
								<td nowrap="nowrap" class="VisualSampleCell" valign="middle">
									<xsl:choose>
										<xsl:when test="count(visual) = 1">
											<xsl:choose>
												<xsl:when test="string-length(visual) &gt; 0"><xsl:value-of select="visual" disable-output-escaping="yes" /></xsl:when>
												<xsl:otherwise>Visual component</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:when test="count(visual-or-nonvisual) = 1">
											<xsl:choose>
												<xsl:when test="string-length(visual-or-nonvisual) &gt; 0"><xsl:value-of select="visual-or-nonvisual" disable-output-escaping="yes" /></xsl:when>
												<xsl:otherwise>Visual or non-visual component</xsl:otherwise>
											</xsl:choose>									
										</xsl:when>
										<xsl:when test="count(nonvisual) = 1">Non-visual component</xsl:when>
									</xsl:choose>
								</td>
							</xsl:when>
							<xsl:otherwise><td>&#160;</td></xsl:otherwise>
						</xsl:choose>						
					</tr>
					<tr>
						<td height="40" colspan="3"></td>
					</tr>
				</table>
				
				<xsl:choose>
					<xsl:when test="description">
						<!-- Description -->
						<table width="100%" border="0" cellpadding="0"
							cellspacing="0">
							<tr>
								<td><span class="Section">Description</span></td>
							</tr>
							<tr>
								<td class="Text"><xsl:value-of
										select="description" disable-output-escaping="yes" /></td>
							</tr>
							<tr>
								<td height="20" colspan="3"></td>
							</tr>
						</table>
					</xsl:when>
				</xsl:choose>
				
				<!-- See also section -->
				<xsl:if test="see-also">
					<table width="100%" border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td><span class="Section">See also</span></td>
						</tr>
						<tr>
							<td class="Text">
								<xsl:for-each select="see-also/component">
									<xsl:if test="position() > 1">,
									</xsl:if>
									<xsl:call-template
										name="InsertSeeAlsoComponent"/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="Text">
								<xsl:for-each select="see-also/java">
									<xsl:if test="position() > 1">,
									</xsl:if>
									<xsl:call-template
										name="InsertSeeAlsoJava"/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td height="20" colspan="3"></td>
						</tr>
					</table>
				</xsl:if>
				
				<!-- Parameters -->
				<xsl:if test="count(parameter) > 0">
					<table width="100%" border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td align="left"><span class="Section">
								Parameters</span></td>
						</tr>
						<xsl:call-template name="RenderParametersTableHeader"/>
					</table>
				</xsl:if>
				
				
				<!-- allow body, allow informal parameters, reserved parameters -->
				<table border="0" cellpadding="0" cellspacing="0">
					
					<!-- allow-body -->
					<tr>
						<td class="Text">Allow body</td>
						<td align="left" valign="middle">
							<xsl:if
								test="@allow-body = 'true'">
									<img src="../../resource/yes.gif"/>
							</xsl:if>
							<xsl:if test="@allow-body = 'false'"> <img
									src="../../resource/no.gif"/>
							</xsl:if>&#160;(<xsl:choose>
							<xsl:when test="@allow-body-extension">
								<xsl:value-of select="@allow-body-extension"/>
							</xsl:when>
							<xsl:when test="@allow-body = 'false'">
								removed</xsl:when>
							<xsl:otherwise>rendered</xsl:otherwise>
							</xsl:choose>)
						</td>
					</tr>
					
					<!-- allow-informal-parameters -->
					<tr>
						<td class="Text">Allow informal
							parameters&#160;&#160;&#160;</td>
						<td align="left" valign="middle"><xsl:if
								test="@allow-informal-parameters = 'true'">
								<img src="../../resource/yes.gif"/></xsl:if><xsl:if
								test="@allow-informal-parameters = 'false'"><img
								src="../../resource/no.gif"/></xsl:if></td>
					</tr>
					
					<!-- reserved-parameters -->
					<tr>
						<td class="Text">Reserved parameters&#160;</td>
						<td align="left" valign="middle">
							<xsl:choose>
								<xsl:when test="count(reserved-parameter) > 0">
									<xsl:for-each select="reserved-parameter">
										<xsl:if test="position() > 1">, </xsl:if>
										<xsl:value-of select="@name" />
									</xsl:for-each>
								</xsl:when>
								<xsl:otherwise>
									&#160;<strong>-</strong>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
					
				</table>

				<!-- html addon -->
				<xsl:if test="html-addon">
					<p>&#160;</p>
					<div>
						<xsl:value-of select="html-addon" disable-output-escaping="yes" />
					</div>					
				</xsl:if>
				
			</body>
		</html>

	</xsl:template>

	<xsl:template name="InsertSeeAlsoComponent">
		<a href="../../{@link}"><xsl:value-of select="@label" /></a>
	</xsl:template>
	
	<xsl:template name="InsertSeeAlsoJava">
		<a href="{@url}"><xsl:value-of select="@label" /></a>
	</xsl:template>
	
	<!-- Renders the header of the parameters table and applies templates to parameters. -->
	<xsl:template name="RenderParametersTableHeader">
		
		<tr>
			<td><table border="0" cellpadding="0" cellspacing="0" width="100%">
				<tr><td colspan="6" height="10"></td></tr>
				<tr>
					<td class="ParameterOthersHeader">name</td>
					<td class="ParameterOthersHeader">type</td>
					<td class="ParameterRequiredHeader">required</td>
					<td class="ParameterDefaultValueHeader">default value</td>
					<td class="ParameterDescriptionHeader">description</td>
				</tr>
				<tr>
					<td colspan="6" height="1" bgcolor="#000000"></td>
				</tr>
				<xsl:apply-templates select="parameter" />
				</table>
			</td>
		</tr>
		
		<tr>
			<td height="20"></td>
		</tr>

	</xsl:template>

	<!-- Renders a row of the parameters table. -->
	<xsl:template match="library[@name=$libraryName]/component[@name=$componentName]/parameter">
		
		<tr>
			<td colspan="6" height="1" bgcolor="#dddddd"></td>
		</tr>
		
		<tr>
			
			<!-- parameter name -->
			<td class="ParameterCell"><xsl:value-of select="@name" /></td>
			
			<!-- parameter type -->
			<td class="ParameterCell">
				<xsl:call-template name="linkToClass" >
					<xsl:with-param name="name" select="type/@name" />
					<xsl:with-param name="link" select="type/@url" />
					<xsl:with-param name="truncateLongerThan" select="number('45')" />
				</xsl:call-template>
			</td>
			
			<!-- required flag -->
			<td class="ParameterCell"><xsl:if test="@required = 'true'"><img src="../../resource/yes.gif" /></xsl:if><xsl:if test="@required = 'false'">&#160;</xsl:if></td>

			<!-- default value -->			
			<td class="ParameterCell">
				<xsl:choose>
					<xsl:when test="0 = count(@default-value)">&#160;</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@default-value" disable-output-escaping="yes" />
					</xsl:otherwise>
				</xsl:choose>
			</td>
			
			<!-- description of the parameter -->
			<td class="ParameterDescriptionCell"><xsl:value-of select="description" disable-output-escaping="yes" />&#160;</td>
			
		</tr>
		
	</xsl:template>

	<xsl:template name="linkToClass">
		<xsl:param name="name" />
		<xsl:param name="link" />
		<xsl:param name="truncateLongerThan" />
		
		<xsl:choose>
			<xsl:when test="$link != ''"><a href="{$link}" title="{$name}"><xsl:call-template name="insertClassName">
					<xsl:with-param name="className" select="$name" />
					<xsl:with-param name="truncateLongerThan" select="$truncateLongerThan" />
				</xsl:call-template></a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="insertClassName">
					<xsl:with-param name="className" select="$name" />
					<xsl:with-param name="truncateLongerThan" select="$truncateLongerThan" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>

	<xsl:template name="insertClassName">
		<xsl:param name="className" /> <!-- class name -->
		<xsl:param name="truncateLongerThan" select="number('1000')" /> <!-- truncate class names which are longer than this value -->
		
		<xsl:choose>
			<xsl:when test="string-length($className) &gt; number($truncateLongerThan)">
				...<xsl:value-of select="substring($className, string-length($className) - number($truncateLongerThan) + 1)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$className" />
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>

	<xsl:template match="library/description" />
		
	<xsl:template match="library[@name = $libraryName]/component[@name != $componentName]" />
	<xsl:template match="library[@name != $libraryName]/component" />

</xsl:stylesheet>
