/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.xml;

import com.erinors.tapestry.tapdoc.xml.XsltException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltUtils {
    private XsltUtils() {
    }

    public static void xsltTransform(Source xmlSource, Result output, Reader xsltReader, Map<String, ?> parameters) throws XsltException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Templates template = factory.newTemplates(new StreamSource(xsltReader));
            Transformer transformer = template.newTransformer();
            if (parameters != null) {
                for (Map.Entry<String, ?> entry : parameters.entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            transformer.transform(xmlSource, output);
        }
        catch (TransformerConfigurationException e) {
            throw new XsltException(e);
        }
        catch (TransformerException e) {
            throw new XsltException(e);
        }
    }

    public static void xsltTransform(Source xmlSource, Result output, Reader xsltReader) throws XsltException {
        XsltUtils.xsltTransform(xmlSource, output, xsltReader, null);
    }

    public static String xsltTransform(String xml, Reader xsltReader, Map<String, ?> parameters) {
        StreamSource xmlSource = new StreamSource(new StringReader(xml));
        StringWriter writer = new StringWriter();
        StreamResult output = new StreamResult(writer);
        XsltUtils.xsltTransform(xmlSource, output, xsltReader, parameters);
        return writer.toString();
    }

    public static String xsltTransform(String xml, InputStream xsltStream, String ... parameters) {
        if (parameters.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of parameters expected (name-value pairs)");
        }
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (int i = 0; i < parameters.length; i += 2) {
            parameterMap.put(parameters[i], parameters[i + 1]);
        }
        return XsltUtils.xsltTransform(xml, xsltStream, parameterMap);
    }

    public static String xsltTransform(String xml, InputStream xsltStream, Map<String, ?> parameters) {
        return XsltUtils.xsltTransform(xml, new InputStreamReader(xsltStream), parameters);
    }

    public static String xsltTransform(String xml, InputStream xsltStream) {
        return XsltUtils.xsltTransform(xml, xsltStream, (Map)null);
    }

    public static void writeXmlDocument(Source xmlSource, Result output) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(xmlSource, output);
        }
        catch (TransformerConfigurationException e) {
            throw new XsltException(e);
        }
        catch (TransformerException e) {
            throw new XsltException(e);
        }
    }

    public static void writeXmlDocument(Document document, Writer writer) {
        XsltUtils.writeXmlDocument(new DOMSource(document), new StreamResult(writer));
    }
}

