/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.xml;

import com.erinors.tapestry.tapdoc.xml.XmlPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.IMarkupWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElement
implements XmlPart {
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<XmlPart> body = new ArrayList<XmlPart>();

    public XmlElement() {
    }

    public XmlElement(String name) {
        this.setName(name);
    }

    public XmlElement(String name, String ... attributes) {
        this(name);
        assert (attributes.length % 2 == 0);
        for (int i = 0; i < attributes.length; i += 2) {
            this.addAttribute(attributes[i], attributes[i + 1]);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public List<XmlPart> getBody() {
        return Collections.unmodifiableList(this.body);
    }

    public void add(XmlPart part) {
        if (part != null) {
            this.body.add(part);
        }
    }

    @Override
    public void toXml(IMarkupWriter out) {
        if (this.getBody().size() == 0) {
            out.beginEmpty(this.getName());
        } else {
            out.begin(this.getName());
        }
        for (Map.Entry<String, String> attribute : this.getAttributes().entrySet()) {
            out.attribute(attribute.getKey(), attribute.getValue());
        }
        if (this.getBody().size() > 0) {
            for (XmlPart part : this.getBody()) {
                part.toXml(out);
            }
            out.end();
        }
    }
}

