/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.hivemind.Resource;

public class ZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractZip(Resource zip, FileObject outputDirectory) {
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(zip.getResourceURL().openStream());
            while ((entry = zis.getNextEntry()) != null) {
                String[] pathElements = entry.getName().split("/");
                FileObject extractDir = outputDirectory;
                for (int i = 0; i < pathElements.length - 1; ++i) {
                    String pathElementName = pathElements[i];
                    FileObject pathElementFile = extractDir.resolveFile(pathElementName);
                    if (!pathElementFile.exists()) {
                        pathElementFile.createFolder();
                    }
                    extractDir = pathElementFile;
                }
                String fileName = entry.getName();
                if (fileName.endsWith("/")) {
                    fileName = fileName.substring(0, fileName.length() - 1);
                }
                if (fileName.contains("/")) {
                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                }
                if (entry.isDirectory()) {
                    extractDir.resolveFile(fileName).createFolder();
                    continue;
                }
                FileObject file = extractDir.resolveFile(fileName);
                file.createFile();
                int size = (int)entry.getSize();
                byte[] unpackBuffer = new byte[size];
                zis.read(unpackBuffer, 0, size);
                ByteArrayInputStream in = null;
                OutputStream out = null;
                try {
                    in = new ByteArrayInputStream(unpackBuffer);
                    out = file.getContent().getOutputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (IOException e2) {
            try {
                throw new RuntimeException(e2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)zis);
    }
}

