/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.util;

import com.erinors.tapestry.tapdoc.mock.MockServlet;
import com.erinors.tapestry.tapdoc.service.Generator;
import com.erinors.tapestry.tapdoc.util.SimpleErrorHandler;
import com.erinors.tapestry.tapdoc.util.TapdocPrefs;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServlet;
import org.apache.commons.vfs.FileObject;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.ModuleDescriptorProvider;
import org.apache.hivemind.Registry;
import org.apache.hivemind.impl.RegistryBuilder;
import org.apache.hivemind.impl.XmlModuleDescriptorProvider;
import org.apache.tapestry.services.ApplicationInitializer;

public class TapdocUtils {
    private static final List<String> DefaultJavadocLinks = Arrays.asList("http://java.sun.com/javase/6/docs/api/", "http://java.sun.com/javaee/5/docs/api/", "http://tapestry.apache.org/tapestry4.1/tapestry-framework/apidocs/");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(ClassResolver classResolver, FileObject outputDirectory, FileObject generatedOutputDirectory, FileObject javaDom, TapdocPrefs prefs) {
        if (prefs.getJavadocLinks() == null) {
            prefs.setJavadocLinks(DefaultJavadocLinks);
        }
        String applicationSpecificationPath = null;
        for (String libraryLocation : prefs.getLibraryLocations()) {
            if (!libraryLocation.endsWith(".application")) continue;
            applicationSpecificationPath = libraryLocation;
            break;
        }
        Thread.currentThread().setContextClassLoader(classResolver.getClassLoader());
        RegistryBuilder builder = prefs.isShowErrors() ? new RegistryBuilder() : new RegistryBuilder((ErrorHandler)new SimpleErrorHandler());
        builder.addModuleDescriptorProvider((ModuleDescriptorProvider)new XmlModuleDescriptorProvider(classResolver));
        Registry registry = builder.constructRegistry(Locale.getDefault());
        try {
            registry.setupThread();
            try {
                ApplicationInitializer ai = (ApplicationInitializer)registry.getService("tapestry.init.MasterInitializer", ApplicationInitializer.class);
                ai.initialize((HttpServlet)new MockServlet(applicationSpecificationPath));
                ((Generator)registry.getService(Generator.class)).generate(registry, outputDirectory, generatedOutputDirectory, javaDom, prefs);
            }
            finally {
                registry.cleanupThread();
            }
        }
        finally {
            registry.shutdown();
        }
    }
}

