/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.service.standalone;

import com.erinors.tapestry.tapdoc.model.Component;
import com.erinors.tapestry.tapdoc.model.Library;
import com.erinors.tapestry.tapdoc.service.DocumentGenerator;
import com.erinors.tapestry.tapdoc.service.FileNameGenerator;
import com.erinors.tapestry.tapdoc.util.ZipUtils;
import com.erinors.tapestry.tapdoc.xml.XsltUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneDocumentGenerator
implements DocumentGenerator {
    private final ClassResolver classResolver;
    private final FileNameGenerator fileNameGenerator;

    public StandaloneDocumentGenerator(ClassResolver classResolver, FileNameGenerator fileNameGenerator) {
        this.classResolver = classResolver;
        this.fileNameGenerator = fileNameGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(FileObject outputDirectory, FileObject generatedOutputDirectory, List<Library> libraryModels, String tapdocXml) throws FileSystemException {
        if (!outputDirectory.exists()) {
            outputDirectory.createFolder();
        }
        ZipUtils.extractZip((Resource)new ClasspathResource(this.classResolver, "/com/erinors/tapestry/tapdoc/standalone/resources.zip"), outputDirectory);
        for (Library library : libraryModels) {
            String libraryName = library.getName();
            String libraryLocation = library.getLocation();
            outputDirectory.resolveFile(this.fileNameGenerator.getLibraryDirectory(libraryLocation)).createFolder();
            try {
                String result = XsltUtils.xsltTransform(tapdocXml, this.getClass().getResourceAsStream("Library.xsl"), "libraryName", libraryName);
                FileObject index = outputDirectory.resolveFile(this.fileNameGenerator.getLibraryDirectory(libraryLocation)).resolveFile("index.html");
                OutputStreamWriter out = new OutputStreamWriter(index.getContent().getOutputStream(), "UTF-8");
                out.write(result);
                ((Writer)out).close();
                result = XsltUtils.xsltTransform(tapdocXml, this.getClass().getResourceAsStream("ComponentIndex.xsl"), "libraryName", libraryName);
                index = outputDirectory.resolveFile(this.fileNameGenerator.getLibraryDirectory(libraryLocation)).resolveFile("components.html");
                out = new OutputStreamWriter(index.getContent().getOutputStream(), "UTF-8");
                out.write(result);
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (Component component : library.getComponents()) {
                String componentName = component.getName();
                System.out.println("Generating " + libraryName + ":" + componentName + "...");
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("libraryName", libraryName);
                parameters.put("componentName", componentName);
                String result = XsltUtils.xsltTransform(tapdocXml, this.getClass().getResourceAsStream("Component.xsl"), parameters);
                Writer out = null;
                try {
                    File[] files;
                    FileObject index = outputDirectory.resolveFile(this.fileNameGenerator.getComponentIndexFile(libraryLocation, componentName, true));
                    out = new OutputStreamWriter(index.getContent().getOutputStream(), "UTF-8");
                    out.write(result);
                    out.close();
                    Resource specificationLocation = component.getSpecificationLocation();
                    if (specificationLocation.getRelativeResource(componentName + "_tapdoc/resource").getResourceURL() == null) continue;
                    File srcResourcesDirectory = new File(specificationLocation.getRelativeResource(componentName + "_tapdoc/resource").getResourceURL().toURI());
                    FileObject dstResourcesFileObject = outputDirectory.resolveFile(this.fileNameGenerator.getComponentDirectory(libraryLocation, componentName)).resolveFile("resource");
                    if (!srcResourcesDirectory.exists() || !srcResourcesDirectory.isDirectory() || (files = srcResourcesDirectory.listFiles()) == null) continue;
                    for (File resource : files) {
                        if (!resource.isFile() || resource.isHidden()) continue;
                        FileObject resourceFileObject = dstResourcesFileObject.resolveFile(resource.getName());
                        resourceFileObject.createFile();
                        FileInputStream inResource = null;
                        OutputStream outResource = null;
                        try {
                            inResource = new FileInputStream(resource);
                            outResource = resourceFileObject.getContent().getOutputStream();
                            IOUtils.copy((InputStream)inResource, (OutputStream)outResource);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(inResource);
                            IOUtils.closeQuietly(outResource);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)inResource);
                        IOUtils.closeQuietly((OutputStream)outResource);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (out == null) continue;
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        OutputStreamWriter out = null;
        try {
            String result = XsltUtils.xsltTransform(tapdocXml, this.getClass().getResourceAsStream("LibraryIndex.xsl"));
            FileObject index = outputDirectory.resolveFile("libraries.html");
            out = new OutputStreamWriter(index.getContent().getOutputStream(), "UTF-8");
            out.write(result);
            ((Writer)out).close();
            result = XsltUtils.xsltTransform(tapdocXml, this.getClass().getResourceAsStream("Overview.xsl"));
            index = outputDirectory.resolveFile("overview.html");
            out = new OutputStreamWriter(index.getContent().getOutputStream(), "UTF-8");
            out.write(result);
            ((Writer)out).close();
            result = XsltUtils.xsltTransform(tapdocXml, this.getClass().getResourceAsStream("AllComponents.xsl"));
            index = outputDirectory.resolveFile("allcomponents.html");
            out = new OutputStreamWriter(index.getContent().getOutputStream(), "UTF-8");
            out.write(result);
            ((Writer)out).close();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
    }

    @Override
    public String getGeneratedFileNameExtension() {
        return "html";
    }
}

