/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.service;

import com.erinors.tapestry.tapdoc.model.Component;
import com.erinors.tapestry.tapdoc.model.Library;
import com.erinors.tapestry.tapdoc.model.Parameter;
import com.erinors.tapestry.tapdoc.service.DocResolver;
import com.erinors.tapestry.tapdoc.service.XmlGenerator;
import com.erinors.tapestry.tapdoc.xml.XmlCdata;
import com.erinors.tapestry.tapdoc.xml.XmlElement;
import com.erinors.tapestry.tapdoc.xml.XmlPart;
import com.erinors.tapestry.tapdoc.xml.XmlText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlGeneratorImpl
implements XmlGenerator {
    private final DocResolver docResolver;

    public XmlGeneratorImpl(DocResolver docResolver) {
        this.docResolver = docResolver;
    }

    @Override
    public XmlPart generateXml(Iterable<Library> libraries) {
        XmlElement doc = new XmlElement("tapdoc");
        for (Library library : libraries) {
            doc.add(this.provideXml(library));
        }
        return doc;
    }

    protected XmlPart provideXml(Library libraryModel) {
        String libraryName = libraryModel.getName();
        XmlElement library = new XmlElement("library");
        library.addAttribute("name", libraryName);
        library.addAttribute("link", this.docResolver.getLibraryUrl(libraryModel.getLocation()));
        if (libraryModel.getDescription() != null) {
            XmlElement description = new XmlElement("description");
            library.add(description);
            description.add(new XmlText(libraryModel.getDescription()));
        }
        for (Component componentModel : libraryModel.getComponents()) {
            library.add(this.provideXml(componentModel, libraryModel));
        }
        return library;
    }

    protected XmlPart provideXml(Component componentModel, Library libraryModel) {
        XmlElement component = new XmlElement("component");
        component.addAttribute("name", componentModel.getName());
        component.addAttribute("link", this.docResolver.getComponentUrl(libraryModel.getLocation(), componentModel.getName()));
        component.addAttribute("allow-body", Boolean.toString(componentModel.getAllowBody()));
        component.addAttribute("allow-informal-parameters", Boolean.toString(componentModel.getAllowInformalParameters()));
        component.addAttribute("deprecated", Boolean.toString(componentModel.isDeprecated()));
        component.addAttribute("global", Boolean.toString(componentModel.isGlobal()));
        XmlElement classNameTag = new XmlElement("class");
        component.add(classNameTag);
        classNameTag.addAttribute("name", componentModel.getComponentClassName());
        classNameTag.addAttribute("url", this.docResolver.getJavadocUrl(componentModel.getComponentClassName(), null));
        if (componentModel.getHasSeeAlsoReferences()) {
            XmlElement seeAlso = new XmlElement("see-also");
            component.add(seeAlso);
            for (String referencedComponent : componentModel.getSeeAlsoComponents()) {
                if (referencedComponent.contains(":")) continue;
                seeAlso.add(new XmlElement("component", "label", referencedComponent, "library", libraryModel.getName(), "component", referencedComponent, "link", this.docResolver.getComponentUrl(libraryModel.getLocation(), referencedComponent)));
            }
            for (String javadocReference : componentModel.getSeeAlsoClasses()) {
                String typeName = javadocReference.contains("#") ? javadocReference.substring(0, javadocReference.indexOf(35)) : javadocReference;
                String memberName = javadocReference.contains("#") ? javadocReference.substring(javadocReference.indexOf(35) + 1) : null;
                String javadocUrl = this.docResolver.getJavadocUrl(typeName, memberName);
                seeAlso.add(new XmlElement("java", "label", javadocReference, "url", javadocUrl));
            }
        }
        if (componentModel.getVisuality() != null) {
            switch (componentModel.getVisuality()) {
                case Visual: {
                    XmlElement visual = new XmlElement("visual");
                    component.add(visual);
                    visual.add(new XmlCdata(componentModel.getVisualSample()));
                    break;
                }
                case VisualOrNonvisual: {
                    XmlElement visual = new XmlElement("visual-or-nonvisual");
                    component.add(visual);
                    visual.add(new XmlCdata(componentModel.getVisualSample()));
                    break;
                }
                case Nonvisual: {
                    XmlElement nonvisual = new XmlElement("nonvisual");
                    component.add(nonvisual);
                }
            }
        }
        if (componentModel.getDescription() != null) {
            XmlElement description = new XmlElement("description");
            component.add(description);
            description.add(new XmlText(componentModel.getDescription()));
        }
        for (String reservedParameter : componentModel.getReservedParameters()) {
            component.add(new XmlElement("reserved-parameter", "name", reservedParameter));
        }
        for (Parameter parameterModel : componentModel.getParameters()) {
            XmlElement parameter = new XmlElement("parameter");
            component.add(parameter);
            parameter.addAttribute("name", parameterModel.getName());
            parameter.addAttribute("required", Boolean.toString(parameterModel.isRequired()));
            if (parameterModel.getDefaultValue() != null) {
                parameter.addAttribute("default-value", parameterModel.getDefaultValue());
            }
            String type = parameterModel.getType();
            XmlElement typeTag = new XmlElement("type");
            parameter.add(typeTag);
            typeTag.addAttribute("name", Object.class.getName().equals(type) ? "object" : type);
            typeTag.addAttribute("url", this.docResolver.getJavadocUrl(type, null));
            parameter.addAttribute("cache", Boolean.toString(parameterModel.isCached()));
            for (String alias : parameterModel.getAliases()) {
                parameter.add(new XmlElement("alias", "name", alias));
            }
            if (parameterModel.getDescription() == null) continue;
            XmlElement paramDescription = new XmlElement("description");
            parameter.add(paramDescription);
            paramDescription.add(new XmlText(parameterModel.getDescription()));
        }
        if (componentModel.getHtmlAddon() != null) {
            XmlElement htmlAddon = new XmlElement("html-addon");
            component.add(htmlAddon);
            htmlAddon.add(new XmlCdata(componentModel.getHtmlAddon()));
        }
        return component;
    }
}

