/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.service;

import com.erinors.tapestry.tapdoc.service.DocumentGenerator;
import com.erinors.tapestry.tapdoc.service.TapdocContext;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.hivemind.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TapdocContextImpl
implements TapdocContext {
    private final DocumentGenerator documentGenerator;
    private final Registry registry;
    private final FileObject javaDom;
    private final List<String> javadocLinks;
    private final List<String> tapdocLinks;
    private final List<String> libraryLocations;
    private final FileObject outputDirectory;

    public TapdocContextImpl(Registry registry, FileObject javaDom, List<String> javadocLinks, List<String> libraryLocations, FileObject outputDirectory, List<String> tapdocLinks, DocumentGenerator documentGenerator) {
        this.registry = registry;
        this.documentGenerator = documentGenerator;
        try {
            if (javaDom == null) {
                javaDom = outputDirectory.resolveFile("tapdoc-javadom.xml");
            }
            if (!javaDom.exists()) {
                javaDom.createFile();
                javaDom.close();
                IOUtils.copy((Reader)new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><tapdoc-javadom></tapdoc-javadom>"), (OutputStream)javaDom.getContent().getOutputStream());
            }
            this.javaDom = javaDom;
            this.javadocLinks = javadocLinks;
            this.tapdocLinks = tapdocLinks;
            this.libraryLocations = libraryLocations;
            this.outputDirectory = outputDirectory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getGeneratedFileNameExtension() {
        return this.documentGenerator.getGeneratedFileNameExtension();
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public FileObject getJavaDom() {
        return this.javaDom;
    }

    @Override
    public List<String> getJavadocLinks() {
        return this.javadocLinks;
    }

    @Override
    public List<String> getTapdocLinks() {
        return this.tapdocLinks;
    }

    @Override
    public List<String> getLibraryLocations() {
        return this.libraryLocations;
    }

    @Override
    public FileObject getOutputDirectory() {
        return this.outputDirectory;
    }
}

