/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.service;

import com.erinors.tapestry.tapdoc.model.Component;
import com.erinors.tapestry.tapdoc.model.Library;
import com.erinors.tapestry.tapdoc.model.Parameter;
import com.erinors.tapestry.tapdoc.service.FileNameGenerator;
import com.erinors.tapestry.tapdoc.service.JavadomParser;
import com.erinors.tapestry.tapdoc.service.ModelSource;
import com.erinors.tapestry.tapdoc.service.TapdocContext;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.digester.Digester;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.asset.AssetSource;
import org.apache.tapestry.engine.ISpecificationSource;
import org.apache.tapestry.engine.Namespace;
import org.apache.tapestry.pageload.ComponentClassProvider;
import org.apache.tapestry.pageload.ComponentClassProviderContext;
import org.apache.tapestry.resolver.ComponentSpecificationResolver;
import org.apache.tapestry.services.ComponentConstructorFactory;
import org.apache.tapestry.services.NamespaceResources;
import org.apache.tapestry.services.impl.NamespaceResourcesImpl;

public class ModelSourceImpl
implements ModelSource {
    private final TapdocContext tapdocContext;
    private final ClassResolver classResolver;
    private final FileNameGenerator fileNameGenerator;
    private final AssetSource assetSource;
    private final ComponentSpecificationResolver componentSpecificationResolver;
    private final ComponentConstructorFactory componentConstructorFactory;
    private final JavadomParser javadocParser;
    private ComponentClassProvider componentClassProvider;
    private ISpecificationSource specificationSource;
    private NamespaceResources namespaceResources;

    public ModelSourceImpl(TapdocContext tapdocContext, ClassResolver classResolver, FileNameGenerator fileNameGenerator, AssetSource assetSource, ComponentSpecificationResolver componentSpecificationResolver, ComponentConstructorFactory componentConstructorFactory, JavadomParser javadocParser) {
        this.tapdocContext = tapdocContext;
        this.classResolver = classResolver;
        this.fileNameGenerator = fileNameGenerator;
        this.assetSource = assetSource;
        this.componentSpecificationResolver = componentSpecificationResolver;
        this.componentConstructorFactory = componentConstructorFactory;
        this.javadocParser = javadocParser;
    }

    public void setComponentClassProvider(ComponentClassProvider componentClassProvider) {
        this.componentClassProvider = componentClassProvider;
    }

    public void setSpecificationSource(ISpecificationSource specificationSource) {
        this.specificationSource = specificationSource;
    }

    public void initialize() {
        this.namespaceResources = new NamespaceResourcesImpl(this.specificationSource, this.assetSource);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Library getLibraryModel(String libraryLocation, boolean ignoreAbstract) {
        location = new ClasspathResource(this.classResolver, libraryLocation);
        specification = libraryLocation.endsWith(".application") != false ? this.specificationSource.getApplicationNamespace().getSpecification() : this.specificationSource.getLibrarySpecification((Resource)location);
        namespace = new Namespace(null, null, specification, this.namespaceResources);
        library = new Library(specification.getComponentTypes());
        library.setName(this.fileNameGenerator.extractLibraryName(libraryLocation));
        library.setLocation(libraryLocation);
        library.setDescription(specification.getDescription());
        extLibraryDocResource = location.getRelativeResource(location.getName().substring(0, location.getName().lastIndexOf(46)) + ".tapdoc.xml");
        if (extLibraryDocResource != null && extLibraryDocResource.getResourceURL() != null) {
            digester = new Digester();
            digester.setValidating(false);
            digester.push((Object)library);
            digester.addCallMethod("tapdoc/documented", "addDocumentedComponent", 1);
            digester.addCallParam("tapdoc/documented", 0);
            try {
                digester.parse((Reader)new InputStreamReader(extLibraryDocResource.getResourceURL().openStream(), "UTF-8"));
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("Cannot process " + extLibraryDocResource, (Throwable)e);
            }
        }
        components = library.getComponentTypes();
        components.addAll(this.javadocParser.getAnnotatedComponent(libraryLocation, ignoreAbstract));
        i$ = components.iterator();
        block16: while (true) {
            if (!i$.hasNext()) {
                return library;
            }
            componentName = i$.next();
            this.componentSpecificationResolver.resolve(null, (INamespace)namespace, componentName, null);
            componentSpecification = this.componentSpecificationResolver.getSpecification();
            context = new ComponentClassProviderContext("PLACEHOLDER", componentSpecification, (INamespace)namespace);
            componentClassName = this.componentClassProvider.provideComponentClassName(context);
            componentClass = HiveMind.isBlank((String)componentClassName) != false ? BaseComponent.class : this.classResolver.findClass(componentClassName);
            try {
                this.componentConstructorFactory.getComponentConstructor(componentSpecification, componentClassName);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            component = new Component();
            library.getComponents().add(component);
            component.setName(componentName);
            component.setSpecificationLocation(componentSpecification.getLocation().getResource());
            globalComponents = Collections.emptyList();
            try {
                globalComponents = this.tapdocContext.getRegistry().getConfiguration("com.erinors.tapestry.nsutils.GlobalComponents");
            }
            catch (Exception e) {
                // empty catch block
            }
            component.setAllowBody(componentSpecification.getAllowBody());
            component.setAllowInformalParameters(componentSpecification.getAllowInformalParameters());
            component.setComponentClassName(componentClassName);
            component.setDeprecated(componentSpecification.isDeprecated());
            if (componentSpecification.getDescription() != null) {
                component.setDescription(componentSpecification.getDescription());
            } else {
                component.setDescription(this.javadocParser.getClassComment(componentClassName));
            }
            extDocResource = componentSpecification.getLocation().getResource().getRelativeResource(componentName + ".tapdoc.xml");
            if (extDocResource != null && extDocResource.getResourceURL() != null) {
                digester = new Digester();
                digester.setValidating(false);
                digester.push((Object)component);
                digester.addCallMethod("tapdoc/see-also/component", "addSeeAlsoComponent", 1);
                digester.addCallParam("tapdoc/see-also/component", 0);
                digester.addCallMethod("tapdoc/see-also/java", "addSeeAlsoClass", 1);
                digester.addCallParam("tapdoc/see-also/java", 0);
                digester.addCallMethod("tapdoc/visual", "setVisual", 1);
                digester.addCallParam("tapdoc/visual", 0);
                digester.addCallMethod("tapdoc/nonvisual", "setNonvisual");
                digester.addCallMethod("tapdoc/visual-or-nonvisual", "setVisualOrNonvisual", 1);
                digester.addCallParam("tapdoc/visual-or-nonvisual", 0);
                digester.addCallMethod("tapdoc/html-addon", "setHtmlAddon", 1);
                digester.addCallParam("tapdoc/html-addon", 0);
                try {
                    digester.parse((Reader)new InputStreamReader(extDocResource.getResourceURL().openStream(), "UTF-8"));
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("Cannot process " + extDocResource, (Throwable)e);
                }
            }
            if ((extResourcesDir = componentSpecification.getLocation().getResource().getRelativeResource(componentName + ".tapdoc.resources")) != null && extResourcesDir.getResourceURL() != null) {
                try {
                    file = new File(extResourcesDir.getResourceURL().toURI());
                    if (file.exists() && !file.isDirectory()) {
                        // empty if block
                    }
                }
                catch (URISyntaxException e) {
                    throw new ApplicationRuntimeException("Cannot process " + extResourcesDir + ". " + e.toString(), (Throwable)e);
                }
            }
            if (componentSpecification.getReservedParameterNames() != null) {
                for (String reservedParameter : componentSpecification.getReservedParameterNames()) {
                    formal = false;
                    for (String formalParam : componentSpecification.getParameterNames()) {
                        if (!reservedParameter.equals(formalParam.toLowerCase())) continue;
                        formal = true;
                        break;
                    }
                    if (formal) continue;
                    component.getReservedParameters().add(reservedParameter);
                }
            }
            if (componentSpecification.getParameterNames() == null) continue;
            i$ = componentSpecification.getParameterNames().iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block16;
                parameterName = (String)i$.next();
                paramSpec = componentSpecification.getParameter(parameterName);
                type = paramSpec.getType();
                parameter = new Parameter();
                parameter.setName(parameterName);
                component.getParameters().add(parameter);
                parameter.setRequired(paramSpec.isRequired());
                parameter.setDeprecated(paramSpec.isDeprecated());
                parameter.setAliases(new HashSet<String>(paramSpec.getAliasNames()));
                parameter.setDescription(paramSpec.getDescription());
                try {
                    getter = null;
                    setter = null;
                    tail = Character.toUpperCase(paramSpec.getPropertyName().charAt(0)) + paramSpec.getPropertyName().substring(1);
                    try {
                        getterName = "get" + tail;
                        getter = componentClass.getMethod(getterName, null);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            boolGetterName = "is" + tail;
                            getter = componentClass.getMethod(boolGetterName, null);
                        }
                        catch (NoSuchMethodException e1) {
                            // empty catch block
                        }
                    }
                    setterName = "set" + tail;
                    for (Method method : componentClass.getMethods()) {
                        if (!method.getName().equals(setterName) || method.getReturnType() != Void.TYPE || method.getParameterTypes().length != 1) continue;
                        setter = method;
                        break;
                    }
                    if (getter != null) {
                        type = getter.getReturnType().getName();
                    } else if (setter != null) {
                        type = setter.getParameterTypes()[0].getName();
                    }
                    if (parameter.getDescription() == null && (getter != null || setter != null)) {
                        parameter.setDescription(this.javadocParser.getAccessorMethodComment(getter, setter));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (type == null) {
                    type = Object.class.getName();
                }
                parameter.setType(type);
                if (paramSpec.getDefaultValue() != null) {
                    parameter.setDefaultValue(paramSpec.getDefaultValue());
                    continue;
                }
                if (parameter.isRequired()) continue;
                implicitDefaultValue = null;
                if (type.equals("boolean")) {
                    implicitDefaultValue = "false";
                } else if (type.equals("char")) {
                    implicitDefaultValue = "'\\u0000'";
                } else if (type.equals("byte") || type.equals("short") || type.equals("int")) {
                    implicitDefaultValue = "0";
                } else if (type.equals("long")) {
                    implicitDefaultValue = "0l";
                } else if (type.equals("float")) {
                    implicitDefaultValue = "0.0f";
                } else if (type.equals("double")) {
                    implicitDefaultValue = "0.0d";
                }
                parameter.setDefaultValue(implicitDefaultValue);
            }
            break;
        }
    }
}

