/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.service;

import com.erinors.tapestry.tapdoc.service.DocResolver;
import com.erinors.tapestry.tapdoc.service.JavadomParser;
import com.erinors.tapestry.tapdoc.service.TapdocContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadomParserImpl
implements JavadomParser {
    private final TapdocContext context;
    private final DocResolver docResolver;
    private XPath xpath;
    private Document javadomDocument;
    private boolean initialized;

    public JavadomParserImpl(TapdocContext context, DocResolver docResolver) {
        this.context = context;
        this.docResolver = docResolver;
    }

    private void initialize() {
        if (!this.initialized) {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            this.xpath = xpathFactory.newXPath();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                this.javadomDocument = factory.newDocumentBuilder().parse(new InputSource(this.context.getJavaDom().getContent().getInputStream()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.initialized = true;
        }
    }

    @Override
    public String getClassComment(String className) {
        this.initialize();
        String classComment = null;
        try {
            XPathExpression expression = this.xpath.compile("/tapdoc-javadom/java-class[@fulltype='" + className + "']/comment/inlineTags/*");
            classComment = this.processComment(expression);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return classComment;
    }

    @Override
    public String getAccessorMethodComment(Method getter, Method setter) {
        this.initialize();
        Method accessor = getter != null ? getter : setter;
        String accessorComment = null;
        if (accessor != null) {
            try {
                XPathExpression expression = this.xpath.compile("/tapdoc-javadom/java-class[@fulltype='" + accessor.getDeclaringClass().getName() + "']/methods/method[@name='" + accessor.getName() + "']/comment/inlineTags/*");
                accessorComment = this.processComment(expression);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return accessorComment;
    }

    private String processComment(XPathExpression expression) throws XPathExpressionException {
        String comment = null;
        NodeList inlineNodes = (NodeList)expression.evaluate(this.javadomDocument, XPathConstants.NODESET);
        if (inlineNodes.getLength() > 0) {
            comment = "";
        }
        for (int i = 0; i < inlineNodes.getLength(); ++i) {
            Node inlineTag = inlineNodes.item(i);
            if (inlineTag.getChildNodes().getLength() <= 0) continue;
            boolean link = inlineTag.getAttributes().getNamedItem("name") != null && "@link".equals(inlineTag.getAttributes().getNamedItem("name").getNodeValue());
            Node text = inlineTag.getChildNodes().item(0);
            boolean disabled = false;
            if (link) {
                Node classNode = inlineTag.getAttributes().getNamedItem("class");
                Node memberNode = inlineTag.getAttributes().getNamedItem("member");
                String url = this.docResolver.getJavadocUrl(classNode != null ? classNode.getNodeValue() : null, memberNode != null ? memberNode.getNodeValue() : null);
                boolean bl = disabled = url == null;
                if (disabled) {
                    comment = comment + "<i>";
                } else {
                    comment = comment + "<a href=\"";
                    comment = comment + url;
                    comment = comment + "\">";
                }
            }
            comment = comment + text.getTextContent();
            if (!link) continue;
            comment = comment + (disabled ? "</i>" : "</a>");
        }
        if (comment != null && comment.length() == 0) {
            comment = null;
        }
        return comment;
    }

    @Override
    public List<String> getAnnotatedComponent(String library, boolean ignoreAbstract) {
        NodeList inlineNodes;
        this.initialize();
        int pos = library.lastIndexOf("/");
        library = library.substring(0, pos).replace('/', '.');
        if (library.startsWith(".")) {
            library = library.substring(1);
        }
        ArrayList<String> components = new ArrayList<String>();
        try {
            XPathExpression expression = this.xpath.compile("/tapdoc-javadom/java-class");
            inlineNodes = (NodeList)expression.evaluate(this.javadomDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            return components;
        }
        for (int i = 0; i < inlineNodes.getLength(); ++i) {
            boolean isComponent;
            NamedNodeMap attrs = inlineNodes.item(i).getAttributes();
            String fulltype = attrs.getNamedItem("fulltype").getNodeValue();
            boolean isAbstract = "true".equals(attrs.getNamedItem("abstract").getNodeValue());
            boolean bl = isComponent = attrs.getNamedItem("tapestry-component") != null;
            if (!fulltype.startsWith(library)) continue;
            String type = fulltype.substring(library.length() + 1);
            type = type.replace('.', '/');
            if (!isComponent && (!isAbstract || ignoreAbstract)) continue;
            components.add(type);
        }
        return components;
    }
}

