/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.service;

import com.erinors.tapestry.tapdoc.model.Library;
import com.erinors.tapestry.tapdoc.service.DocumentGenerator;
import com.erinors.tapestry.tapdoc.service.FileNameGenerator;
import com.erinors.tapestry.tapdoc.service.Generator;
import com.erinors.tapestry.tapdoc.service.ModelSource;
import com.erinors.tapestry.tapdoc.service.TapdocContext;
import com.erinors.tapestry.tapdoc.service.TapdocContextImpl;
import com.erinors.tapestry.tapdoc.service.XmlGenerator;
import com.erinors.tapestry.tapdoc.util.TapdocPrefs;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Registry;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.markup.MarkupFilter;
import org.apache.tapestry.markup.MarkupWriterImpl;
import org.apache.tapestry.markup.UTFMarkupFilter;

public class GeneratorImpl
implements Generator {
    private final ClassResolver classResolver;
    private final FileNameGenerator fileNameGenerator;
    private final XmlGenerator xmlGenerator;
    private final ModelSource modelSource;
    private TapdocContext context;

    public GeneratorImpl(ClassResolver classResolver, FileNameGenerator fileNameGenerator, XmlGenerator xmlGenerator, ModelSource modelSource) {
        this.classResolver = classResolver;
        this.fileNameGenerator = fileNameGenerator;
        this.xmlGenerator = xmlGenerator;
        this.modelSource = modelSource;
    }

    public TapdocContext getContext() {
        return this.context;
    }

    public void generate(Registry registry, FileObject outputDirectory, FileObject generatedOutputDirectory, FileObject javaDom, TapdocPrefs prefs) {
        try {
            DocumentGenerator generator = (DocumentGenerator)registry.getService("com.erinors.tapestry.tapdoc.XdocDocumentGenerator", DocumentGenerator.class);
            this.context = new TapdocContextImpl(registry, javaDom, prefs.getJavadocLinks(), prefs.getLibraryLocations(), outputDirectory, prefs.getTapdocLinks(), generator);
            StringWriter buffer = new StringWriter();
            MarkupWriterImpl writer = new MarkupWriterImpl("text/xml", new PrintWriter(buffer), (MarkupFilter)new UTFMarkupFilter());
            ArrayList<Library> libraryModels = new ArrayList<Library>();
            for (String libraryLocation : prefs.getLibraryLocations()) {
                libraryModels.add(this.modelSource.getLibraryModel(libraryLocation, prefs.isIgnoreAbstract()));
            }
            this.xmlGenerator.generateXml(libraryModels).toXml((IMarkupWriter)writer);
            String xml = buffer.toString();
            generator.generate(outputDirectory, generatedOutputDirectory, libraryModels, xml);
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.context = null;
        }
    }
}

