/*
 * Decompiled with CFR 0.152.
 */
package com.erinors.tapestry.tapdoc.service;

import com.erinors.tapestry.tapdoc.service.FileNameGenerator;
import com.erinors.tapestry.tapdoc.service.TapdocContext;
import java.util.HashMap;
import java.util.Map;

public class FileNameGeneratorImpl
implements FileNameGenerator {
    private final TapdocContext context;
    private Map<String, String> libraryNameCache = new HashMap<String, String>();

    public FileNameGeneratorImpl(TapdocContext context) {
        this.context = context;
    }

    public String getLibraryDirectory(String libraryLocation) {
        assert (libraryLocation != null && libraryLocation.startsWith("/") && libraryLocation.contains("."));
        return libraryLocation.substring(1, libraryLocation.lastIndexOf(".")).replaceAll("/", ".");
    }

    public String getComponentDirectory(String libraryLocation, String componentName) {
        assert (libraryLocation != null && libraryLocation.startsWith("/") && libraryLocation.contains("."));
        assert (componentName != null);
        return this.getLibraryDirectory(libraryLocation) + "/" + componentName;
    }

    public String getComponentIndexFile(String libraryLocation, String componentName, boolean forGenerating) {
        return this.getComponentDirectory(libraryLocation, componentName) + "/index." + (forGenerating ? this.context.getGeneratedFileNameExtension() : "html");
    }

    public String extractLibraryName(String libraryLocation) {
        assert (libraryLocation != null && libraryLocation.startsWith("/") && libraryLocation.contains("."));
        String name = this.libraryNameCache.get(libraryLocation);
        if (name == null) {
            name = libraryLocation.substring(libraryLocation.lastIndexOf("/") + 1, libraryLocation.lastIndexOf(46));
            if (this.libraryNameCache.containsValue(name)) {
                int index = 1;
                while (this.libraryNameCache.containsValue(name + " (" + index + ")")) {
                    ++index;
                }
                name = name + " (" + index + ")";
            }
            this.libraryNameCache.put(libraryLocation, name);
        }
        return name;
    }
}

